/*
 * Decompiled with CFR 0.152.
 */
package cz.luboss.medulla.common;

import cz.luboss.lubosslib.LException;
import cz.luboss.medulla.data.MeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MeTransact {
    protected Map m_mpActualItem = new HashMap();
    protected List m_arrTransact = new ArrayList();

    public static MeTransact CreateInstance() {
        MeTransact transact = new MeTransact();
        return transact;
    }

    public Collection GetTransactionData() {
        return ((HashMap)this.m_arrTransact.get(this.m_arrTransact.size() - 1)).values();
    }

    public boolean TransactionIsLast() {
        return this.m_arrTransact.size() == 1;
    }

    public boolean StartTransaction() {
        this.m_arrTransact.add(new HashMap());
        return true;
    }

    public boolean RollBack() {
        if (this.m_arrTransact.size() == 0) {
            throw new LException(this.getClass(), "Funkce RollBack() musi ukoncovat beh funkce StartTransaction()");
        }
        Map mapa = (Map)this.m_arrTransact.get(this.m_arrTransact.size() - 1);
        Iterator iter = mapa.values().iterator();
        while (iter.hasNext()) {
            this.UnRegister((MeItem)iter.next());
        }
        this.m_arrTransact.remove(this.m_arrTransact.size() - 1);
        return true;
    }

    public boolean Commit() {
        if (this.m_arrTransact.size() == 0) {
            throw new LException(this.getClass(), "Funkce Commit() musi ukoncovat beh funkce StartTransaction()");
        }
        if (this.m_arrTransact.size() != 1) {
            Map mapa = (Map)this.m_arrTransact.get(this.m_arrTransact.size() - 1);
            Map mapaPrew = (Map)this.m_arrTransact.get(this.m_arrTransact.size() - 2);
            mapaPrew.putAll(mapa);
        }
        this.m_arrTransact.remove(this.m_arrTransact.size() - 1);
        return true;
    }

    public boolean Register(MeItem item) {
        String sKod;
        if (this.m_arrTransact.size() == 0) {
            throw new LException(this.getClass(), "Funkce Register() musi byt spustena v transakci");
        }
        if (!item.isIDGenerate()) {
            throw new LException(this.getClass(), "Novy objekt neni mozne zaregistrovat bez vygenerovaneho ID");
        }
        Map mapa = (Map)this.m_arrTransact.get(this.m_arrTransact.size() - 1);
        if (mapa.containsKey(sKod = item.generateKod())) {
            item.setData((MeItem)mapa.get(sKod));
        } else {
            mapa.put(sKod, item);
        }
        if (this.m_mpActualItem.containsKey(sKod)) {
            ((MeItem)this.m_mpActualItem.get(sKod)).setData(item);
        } else {
            this.m_mpActualItem.put(sKod, item);
        }
        return true;
    }

    public boolean UnRegister(MeItem item) {
        if (this.m_arrTransact.size() == 0) {
            throw new LException(this.getClass(), "Funkce UnRegister() musi byt spustena v transakci");
        }
        String sKod = item.generateKod();
        MeItem itemLast = null;
        for (int i = this.m_arrTransact.size() - 2; i >= 0; --i) {
            Map mapa = (Map)this.m_arrTransact.get(i);
            if (!mapa.containsKey(item.generateKod())) continue;
            itemLast = (MeItem)mapa.get(sKod);
            break;
        }
        if (itemLast == null) {
            this.m_mpActualItem.remove(sKod);
        } else {
            ((MeItem)this.m_mpActualItem.get(sKod)).setData(itemLast);
        }
        return true;
    }

    public boolean IsInActual(String sKod) {
        return this.m_mpActualItem.containsKey(sKod);
    }

    public MeItem GetFromActual(String sKod) {
        return (MeItem)this.m_mpActualItem.get(sKod);
    }

    public boolean SetToActual(MeItem item) {
        String sKod = item.generateKod();
        if (this.m_mpActualItem.containsKey(sKod)) {
            item.setData((MeItem)this.m_mpActualItem.get(sKod));
            return false;
        }
        this.m_mpActualItem.put(sKod, item);
        return true;
    }

    public String toString() {
        String sData = "";
        for (int i = this.m_arrTransact.size() - 1; i <= 0; --i) {
            sData = sData + "Transakce [" + i + "]\n";
            Map mapa = (Map)this.m_arrTransact.get(i);
            Iterator iter = mapa.keySet().iterator();
            while (iter.hasNext()) {
                MeItem item = (MeItem)iter.next();
                sData = sData + "  Item [" + item + "] " + item.getStatus() + "\n";
            }
        }
        return sData;
    }
}

