/*
 * Decompiled with CFR 0.152.
 */
package cz.luboss.medulla.factory;

import cz.luboss.lubosslib.LException;
import cz.luboss.medulla.common.MeDataTest;
import cz.luboss.medulla.common.MePodminka;
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.factory.MeConnect;
import cz.luboss.medulla.factory.MeConnectSQL;
import cz.luboss.medulla.factory.MeDataMachine;
import cz.luboss.medulla.factory.MeParamSQL;
import cz.luboss.medulla.types.MeFieldDATE;
import cz.luboss.medulla.types.MeFieldFLOAT;
import cz.luboss.medulla.types.MeFieldINT;
import cz.luboss.medulla.types.MeFieldREF;
import cz.luboss.medulla.types.MeFieldSTRING;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;

public abstract class MeDataMachineSQL
implements MeDataMachine {
    MeParamSQL m_iParamSQL;
    protected MeConnectSQL m_dtConnectSQL;
    static /* synthetic */ Class class$cz$luboss$medulla$factory$MeDataMachineSQL;

    public boolean SetConnect(MeConnect dbConnect) {
        this.m_dtConnectSQL = (MeConnectSQL)dbConnect;
        return true;
    }

    public MeConnect GetConnect() {
        return this.m_dtConnectSQL;
    }

    public void setParamSQL(MeParamSQL param) {
        this.m_iParamSQL = param;
    }

    public MeParamSQL getParamSQL() {
        return this.m_iParamSQL;
    }

    public MeDataTest sendTest(MeDataTest message) {
        String sSQLQuery = "SELECT CURDATE() as test ";
        String sRet = "";
        try {
            Statement stm = this.m_dtConnectSQL.GetDB().GetConect().createStatement();
            MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);
            ResultSet rs = stm.executeQuery(sSQLQuery);
            if (rs.next()) {
                sRet = rs.getString("test");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "Chyba pri spousteni SQL testu");
        }
        return new MeDataTest(27, sRet);
    }

    public MeArray GetActualSessions() {
        return null;
    }

    public boolean IsValidSession(int nSessionID) {
        return true;
    }

    public boolean LoadData(int nSessionID, MeItem item, int nID) {
        String sSQLQuery = this.getParamSQL().getSQL_SELECT(item);
        try {
            sSQLQuery = sSQLQuery + " AND " + item.getNameID() + " = " + nID;
            Statement stm = this.m_dtConnectSQL.GetDB().GetConect().createStatement();
            MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);
            ResultSet rs = stm.executeQuery(sSQLQuery);
            if (!rs.next()) {
                return false;
            }
            MeDataMachineSQL.LoadFromRes(item, rs);
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "LoadData SQL Error [" + sSQLQuery + "]", e);
        }
        return true;
    }

    public boolean LoadArray(int nSessionID, MeArray array, MePodminka podminka) {
        String sSQLQuery = this.getParamSQL().getSQL_SELECT(array);
        try {
            array.clear();
            if (podminka != null) {
                sSQLQuery = sSQLQuery + " AND " + podminka.GetSQLQuery();
            }
            Statement stm = this.m_dtConnectSQL.GetDB().GetConect().createStatement();
            MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);
            ResultSet rs = stm.executeQuery(sSQLQuery);
            while (rs.next()) {
                MeItem newItem = array.addItem();
                MeDataMachineSQL.LoadFromRes(newItem, rs);
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "LoadArray SQL Error [" + sSQLQuery + "]", e);
        }
        return true;
    }

    public boolean SaveTrans(int nSessionID, Collection arrTransData) {
        Iterator iter = arrTransData.iterator();
        while (iter.hasNext()) {
            MeItem item = (MeItem)iter.next();
            String sTable = this.getParamSQL().getSQL_INSERT(item);
            String sSQLQuery = "EMPTY";
            try {
                boolean bFirst = true;
                if (item.isNew()) {
                    sSQLQuery = "INSERT INTO " + sTable + "(";
                    String sSQLQueryPom = ") VALUES(";
                    for (int i = 0; i < item.getParamCount(); ++i) {
                        sSQLQuery = sSQLQuery + (bFirst ? "" : ", ") + item.getParam(i).GetName();
                        sSQLQueryPom = sSQLQueryPom + (bFirst ? "" : ", ") + item.getParam(i).GetSQLString();
                        bFirst = false;
                    }
                    sSQLQuery = sSQLQuery + sSQLQueryPom + ")";
                } else if (item.isDeleted()) {
                    sSQLQuery = "DELETE FROM " + sTable + " WHERE " + item.getNameID() + " = " + item.getID();
                } else {
                    sSQLQuery = "UPDATE  " + sTable + " SET ";
                    for (int i = 0; i < item.getParamCount(); ++i) {
                        sSQLQuery = sSQLQuery + (bFirst ? "" : ", ") + item.getParam(i).GetName() + " = " + item.getParam(i).GetSQLString();
                        bFirst = false;
                    }
                    sSQLQuery = sSQLQuery + " WHERE " + item.getParam(item.getFieldID()).GetName() + " = " + item.getID();
                }
                MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);
                this.m_dtConnectSQL.GetDB().GetConect().createStatement().executeUpdate(sSQLQuery);
            }
            catch (Exception e) {
                throw new LException(this.getClass(), "SaveTrans SQL Error [" + sSQLQuery + "]", e);
            }
        }
        return true;
    }

    public int AddSequenceID(int nSessionID, MeItem item) {
        int nID = 0;
        String sSQLQuery = "";
        try {
            String sInsertTable = this.getParamSQL().getSQL_INSERT(item);
            sSQLQuery = "SELECT count(*), MAX(sqcounter)+1 from " + MedullaContext.getConfParam("SEQUENCE_TABLE") + " where sqname = '" + sInsertTable + "'";
            Statement stm = this.m_dtConnectSQL.GetDB().GetConect().createStatement();
            MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);
            ResultSet rs = stm.executeQuery(sSQLQuery);
            if (rs.next() && rs.getInt("count(*)") != 0) {
                nID = rs.getInt("MAX(sqcounter)+1");
                sSQLQuery = "UPDATE " + MedullaContext.getConfParam("SEQUENCE_TABLE") + " SET sqcounter = " + nID + " where sqname = '" + sInsertTable + "'";
            } else {
                sSQLQuery = "INSERT INTO " + MedullaContext.getConfParam("SEQUENCE_TABLE") + "(sqname, sqcounter)" + " VALUES ('" + sInsertTable + "', 0)";
            }
            rs.close();
            stm.close();
            MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);
            this.m_dtConnectSQL.GetDB().GetConect().createStatement().executeUpdate(sSQLQuery);
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "AddSequenceID Error [" + sSQLQuery + "]", e);
        }
        return nID;
    }

    private static void LoadFromRes(MeItem item, ResultSet rs) {
        try {
            block9: for (int i = 0; i < item.getParamCount(); ++i) {
                switch (item.getParam(i).GetType()) {
                    case 0: {
                        ((MeFieldINT)item.getParam(i)).SetInt(rs.getInt(i + 1));
                        continue block9;
                    }
                    case 1: {
                        ((MeFieldFLOAT)item.getParam(i)).SetFloat(rs.getFloat(i + 1));
                        continue block9;
                    }
                    case 2: {
                        ((MeFieldDATE)item.getParam(i)).SetDate(rs.getDate(i + 1));
                        continue block9;
                    }
                    case 3: {
                        ((MeFieldSTRING)item.getParam(i)).SetString(rs.getString(i + 1));
                        continue block9;
                    }
                    case 4: {
                        ((MeFieldREF)item.getParam(i)).SetRefID(rs.getInt(i + 1));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new LException(class$cz$luboss$medulla$factory$MeDataMachineSQL == null ? (class$cz$luboss$medulla$factory$MeDataMachineSQL = MeDataMachineSQL.class$("cz.luboss.medulla.factory.MeDataMachineSQL")) : class$cz$luboss$medulla$factory$MeDataMachineSQL, "LoadFromRes ", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

