/*
 * Decompiled with CFR 0.152.
 */
package cz.luboss.medulla.server;

import cz.luboss.medulla.common.MeDataTest;
import cz.luboss.medulla.common.MePodminka;
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.data.MeSession;
import cz.luboss.medulla.factory.MedullaRMI;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;

public class MeServerRMI
extends UnicastRemoteObject
implements MedullaRMI {
    public boolean m_bLogClient = false;
    public MeArray m_arrSess;

    public boolean SaveLog(int nSessionID, String sLog) {
        MeSession sess = (MeSession)this.m_arrSess.getItemByID(nSessionID);
        if (sess == null) {
            return false;
        }
        return sess.saveLog(sLog);
    }

    public MeDataTest sendTest(MeDataTest message) {
        return MedullaContext.GetMachine().sendTest(message);
    }

    public MeSession LoadSession(String sLogin, String sPassword) {
        MedullaContext.StartTransaction();
        MeSession sesna = MedullaContext.GetMachine().LoadSession(sLogin, sPassword);
        this.m_arrSess.addItem(sesna);
        MedullaContext.Commit();
        this.m_bLogClient = MedullaContext.getConfParam("DEBUG_CLIENT").equals("TRUE");
        return sesna;
    }

    public MeArray GetActualSessions() {
        return this.m_arrSess;
    }

    public boolean IsValidSession(int nSessionID) {
        return true;
    }

    public MeItem LoadDataRMI(int nSessionID, MeItem item, int nID) {
        if (this.m_bLogClient) {
            String sLog = "LoadDataRMI(" + item.getClass().getName() + ", [" + nID + "]";
            this.SaveLog(nSessionID, sLog);
        }
        if (MedullaContext.GetMachine().LoadData(nSessionID, item, nID)) {
            return item;
        }
        return null;
    }

    public MeArray LoadArrayRMI(int nSessionID, MeArray arrayItem, MePodminka podminka) {
        if (this.m_bLogClient) {
            String sLog = "LoadArrayRMI(" + arrayItem.getClass().getName() + ", " + (podminka == null ? "null" : podminka.getClass().getName()) + "[" + (podminka == null ? "null" : podminka.GetSQLQuery()) + "])";
            this.SaveLog(nSessionID, sLog);
        }
        if (MedullaContext.GetMachine().LoadArray(nSessionID, arrayItem, podminka)) {
            return arrayItem;
        }
        return null;
    }

    public boolean SaveTrans(int nSessionID, Collection arrTransData) {
        if (this.m_bLogClient) {
            this.SaveLog(nSessionID, "SaveTrans(" + arrTransData.size() + ")");
        }
        return MedullaContext.GetMachine().SaveTrans(nSessionID, arrTransData);
    }

    public int AddSequenceID(int nSessionID, MeItem item) {
        if (this.m_bLogClient) {
            this.SaveLog(nSessionID, "AddSequenceID(" + item.getClass().getName() + ")");
        }
        return MedullaContext.GetMachine().AddSequenceID(nSessionID, item);
    }
}

