/*
 * Decompiled with CFR 0.152.
 */
package cz.luboss.pensum.client;

import cz.luboss.pensum.client.panel.PcJobsActualPanel;
import cz.luboss.pensum.client.panel.PcMaterialsPanel;
import cz.luboss.pensum.client.panel.PcPartsPanel;
import cz.luboss.pensum.client.panel.PcPlacesPanel;
import cz.luboss.pensum.client.panel.PcProductsPanel;
import cz.luboss.pensum.client.panel.PcWorkersPanel;
import cz.luboss.pensum.common.PensumContext;
import cz.luboss.pensum.factory.PeDataMachineSQL;
import cz.luboss.pensum.gener.PeParamSQL_MySQL;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TestPeClient
extends JPanel {
    private static final int PREFERRED_WIDTH = 800;
    private static final int PREFERRED_HEIGHT = 550;
    private static int numSSs = 0;
    private static Vector swingSets = new Vector();
    private JFrame m_frame = null;
    static String[] m_args = null;

    public TestPeClient(GraphicsConfiguration gc) {
        this.m_frame = TestPeClient.createFrame(gc);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 550));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
            }
        });
        this.InitializeWindow();
        this.m_frame.pack();
        this.showWeaver();
    }

    public JFrame getFrame() {
        return this.m_frame;
    }

    public void showWeaver() {
        if (this.getFrame() != null) {
            JFrame f = this.getFrame();
            f.setTitle("Pensum");
            f.getContentPane().add((Component)this, "Center");
            f.pack();
            Rectangle screenRect = f.getGraphicsConfiguration().getBounds();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(f.getGraphicsConfiguration());
            int centerWidth = screenRect.width < f.getSize().width ? screenRect.x : screenRect.x + screenRect.width / 2 - f.getSize().width / 2;
            int centerHeight = screenRect.height < f.getSize().height ? screenRect.y : screenRect.y + screenRect.height / 2 - f.getSize().height / 2;
            centerHeight = centerHeight < screenInsets.top ? screenInsets.top : centerHeight;
            f.setLocation(centerWidth, centerHeight);
            f.setVisible(true);
            ++numSSs;
            swingSets.add(this);
        }
    }

    public static void main(String[] args) {
        m_args = args;
        TestPeClient app = new TestPeClient(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
    }

    public static JFrame createFrame(GraphicsConfiguration gc) {
        JFrame frame = new JFrame(gc);
        if (numSSs == 0) {
            frame.setDefaultCloseOperation(3);
        } else {
            WindowAdapter l = new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    numSSs--;
                    swingSets.remove(this);
                }
            };
            frame.addWindowListener(l);
        }
        return frame;
    }

    public void InitializeWindow() {
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        this.add((Component)top, "North");
        JTextField statusField = new JTextField("Pensum 0.1");
        statusField.setEditable(false);
        this.add((Component)statusField, "South");
        PeDataMachineSQL dataMachine = PeDataMachineSQL.CreateInstance(PeParamSQL_MySQL.createInstance());
        PensumContext.CreateInstance("penclient.cfg", 0, "lc", "");
        JTabbedPane m_TabbedPane = new JTabbedPane();
        m_TabbedPane.addTab("B\u011b\u009e\u00edc\u00ed p\u0159\u00edkazy", PcJobsActualPanel.CreateInstance(this.m_frame));
        m_TabbedPane.addTab("V\u00fdrobky", PcProductsPanel.CreateInstance(this.m_frame));
        m_TabbedPane.addTab("D\u00edlce", PcPartsPanel.CreateInstance(this.m_frame));
        m_TabbedPane.addTab("Matro\u009a", PcMaterialsPanel.CreateInstance(this.m_frame));
        m_TabbedPane.addTab("Pracovi\u009at\u011b", PcPlacesPanel.CreateInstance(this.m_frame));
        m_TabbedPane.addTab("Pracovn\u00edci", PcWorkersPanel.CreateInstance(this.m_frame));
        top.add((Component)m_TabbedPane, "Center");
        this.m_frame.getContentPane().add(top);
        this.m_frame.pack();
    }
}

