
package cz.luboss.medulla.client.dlg;

import java.awt.*;
import java.awt.event.*;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.*;

// definice
import cz.luboss.medulla.types.*; 

/**
 * Dialog pro jeden parametr MeField
 * 
 * @author LKC
*/
public class McDlgParam extends JDialog {
	
	/** Parametr */
	MeField m_iField;

///////////////////////////////////////////////////////////////////////

	/** Nadrazeny frame */
  Frame m_frParent = null;
//  JWorkData m_WorkData = null;

  // hodnoty dialogu
//  private String m_sValue;
//  private String m_sDesc;
//  private String m_sType;

  // pripadne combo
//  Vector m_arrComboNameString = null;
//  Vector m_arrComboValueString = null;

  /** Textova hodnota parametru */
  private JFormattedTextField m_fldValue = new JFormattedTextField();

  // pripadny combobox
//  private JComboBox  m_comValue  = new JComboBox();

 	/** Tlacitko OK */
  private JButton m_okButton     = new JButton("OK");
  /** Tlacitko Storno */
  private JButton m_cancelButton = new JButton("Storno");
  /** Pripadny buton pro vyber z ciselniku */
  private JButton m_selectButton = new JButton("Vybrat ze ...");

	/** Kostruktor */
	public McDlgParam (Frame frame) {
		super(frame, "Nastaven parametru", true);
	}

	/** 
	 * Vytvori dialog
	 * 
	 * @param frame prislusny frame 
	 * @param iField zobrazovany parametr
	 * @return novy dialog 
	*/
  public static McDlgParam CreateDlg(Frame frame, MeField iField) {
		McDlgParam dlg = new McDlgParam(frame);
	// nahrajeme data
		dlg.m_iField = iField;    
//    setAlignmentX(CENTER_ALIGNMENT);
//    setAlignmentY(CENTER_ALIGNMENT);

//    m_frParent = frame;
//    m_WorkData = WorkData;

    // hodnoty
/*    m_sValue = sValue;
    m_sDesc = sTitle;
    m_sType = sType;
    m_arrComboNameString = arrComboNameString;
    m_arrComboValueString = arrComboValueString;
*/
    // zakazeme zmenu velikosti
		dlg.setResizable(false);

    // pripravime dialog
		dlg.Inicialize();
		return dlg;
  }

  /** 
   * Inicializuje dialog 
   *
   * @return prubeh metody  
  */  
  public boolean Inicialize() {
    JPanel ButtonPane = new JPanel();
    ButtonPane.setLayout(new BoxLayout(ButtonPane, BoxLayout.X_AXIS));
    ButtonPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    ButtonPane.add(Box.createHorizontalGlue());

    // rozdelime podle typu
		String sValue = m_iField.GetString(); 
    if ( m_iField.GetType() == MeField.INTEGER 
    	|| m_iField.GetType() == MeField.FLOAT ) {
      NumberFormat frField = NumberFormat.getIntegerInstance();
      frField.setParseIntegerOnly(true);
      m_fldValue = new JFormattedTextField(frField);
		// datum
    } else if ( m_iField.GetType() == MeField.DATE) {
      SimpleDateFormat dtFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
      m_fldValue = new JFormattedTextField(dtFormat);
      if (sValue.length() == 0)
        sValue = dtFormat.format(new Date());
		// reference
    } else if ( m_iField.GetType() == MeField.REF) {
    	// nastavime Read only
      m_fldValue.setEditable(false);
    }
/*    else if ( m_sType.compareTo(JWorkAttrib.DEF_ATRIB_FILENAME) == 0) {
      JButton FileSel = new JButton("...");
      FileSel.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          FileDialog dlg = new FileDialog(m_frParent, "Naten souboru", FileDialog.LOAD);
          // pokud mame hodnotu jiz naplnenou
          if (m_sValue.length() != 0)
            dlg.setFile(m_sValue);
          dlg.show();
          // pokud neco vybral
          if (dlg.getFile() != null) {
            // pokud jsme potvrdily zapisem hodnotu
            m_sValue = dlg.getDirectory() + dlg.getFile();
            m_fldValue.setText(m_sValue);
          }
        }
      });
      // a tady pridame
      ButtonPane.add(FileSel);
      ButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
    }
    else if ( m_sType.compareTo(JWorkAttrib.DEF_ATRIB_PERFORMER) == 0) {
      JButton PerformerSel = new JButton("Vbr");
      PerformerSel.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          JMOSelectDialog dlg = new JMOSelectDialog(m_frParent, m_WorkData);
          dlg.showDialog();
          // pokud jsme stiskli OK
          if (dlg.m_nButton == 1) {
            m_sValue = dlg.GetResult();
            m_fldValue.setText(m_sValue);
          }
        }
      });
      // a tady pridame
      ButtonPane.add(PerformerSel);
      ButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
    }
    else if ( m_sType.compareTo(JWorkAttrib.DEF_USER_NUMBER) == 0	) {
      NumberFormat frField = NumberFormat.getIntegerInstance();
      frField.setParseIntegerOnly(true);
      m_fldValue = new JFormattedTextField(frField);
    }
*/
    // Combo musime resit samostatne
/*    if ( m_sType.startsWith(JWorkAttrib.DEF_USER_COMBO)) {
      if (m_arrComboNameString == null)
        return;

      int nSelectItem = 0;
      // prozatim nacteme jenom
      for(int i = 0; i < m_arrComboNameString.size(); i++) {
        String sPopis = (String)m_arrComboValueString.elementAt(i);
        m_comValue.addItem(m_arrComboNameString.elementAt(i));
        // pokud je to nase hodnota
        if (sPopis.compareTo(m_sValue) == 0)
          nSelectItem = i;
      }
      m_comValue.setSelectedIndex(nSelectItem);
      m_comValue.setPreferredSize(new Dimension(250,28));

      // a tady pridame
      ButtonPane.add(m_comValue);
      ButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
   }
   else {
*/     m_fldValue.setText(sValue);
     // nastavime rozmer
     m_fldValue.setPreferredSize(new Dimension(250,28));
     // a tady pridame
     ButtonPane.add(m_fldValue);
     ButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
//   }

    ////////////////////////////////////////////////////////////////////////////////
    //Panel s butonkama
    m_okButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        // pokud je to Combo, ulozime vybrane
//        if ( m_sType.startsWith(JWorkAttrib.DEF_USER_COMBO) && m_arrComboNameString != null)
//          m_sValue = Integer.toString(m_comValue.getSelectedIndex());
//        else
	  		if ( m_iField.GetType() == MeField.DATE) {
					// pokud je to datum, ulozime vybrane
					((MeFieldDATE) m_iField).SetString(m_fldValue.getText(), "dd.MM.yyyy HH:mm:ss");
	  		} else if ( m_iField.GetType() == MeField.REF) {
					// pokud je to reference, uz mame ulozino
	  		} else {
					m_iField.SetString(m_fldValue.getText());
	  		}
        setVisible(false);
      }
    });
    m_cancelButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        setVisible(false);
      }
    });
		m_selectButton.addActionListener(new ActionListener() {
		  public void actionPerformed(ActionEvent e) {
				McDlgSelect dlg = McDlgSelect.CreateDlg(null, (MeFieldREF) m_iField);
				dlg.showDialog();
				// nastavime vybranou hodnotu
				m_fldValue.setText(m_iField.GetString());
		  }
		});
	
    getRootPane().setDefaultButton(m_cancelButton);

    ButtonPane.add(m_okButton);
    ButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
    ButtonPane.add(m_cancelButton);
		// poked se jedna o referenci pridame i button
		if ( m_iField.GetType() == MeField.REF) {
			ButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
			ButtonPane.add(m_selectButton);
		}
		
    ////////////////////////////////////////////////////////////////////////////////
    // a slozime to
    Container contentPane = getContentPane();
    contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
    contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
    contentPane.add(ButtonPane);

    pack();
		return true;
  }

	/** 
	 * Zobrazi dialog 
	 *
	 * @return prubeh metody  
	*/  
  public boolean showDialog() {
    // proste nevim, jak vycentrovat
    Point p = new Point(250, 296);
    setLocation(p);

    setVisible(true);
    return true;
  }
/*
  // vrati pripadny vybrany result COmba
  public String GetResult() {
    return m_sValue;
  }

  // vrati stisknuty button
  public int GetButton() {
    return m_nButton;
  }
*/
}