package cz.luboss.medulla.client.view;

import javax.swing.event.ListSelectionEvent;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.client.view.McGrid;
import cz.luboss.medulla.common.MeColumn;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.data.MeUniSQLArray;
import cz.luboss.medulla.data.MeUniSQLItem;

/**
 * Univerzalni grid
 * 
 * @author LKC
*/
public class McUniGrid extends McGrid {
	
	/** ID vybraneho prvku */
	int m_nSelectID = -1;

	/** 
	 * Udalost na zmenu kurzoru v gridu 
	 * 
	 * @param e udalost zmeny
	*/
	public void EventChangeGrid(ListSelectionEvent e) {
		// zavolama nadrazeny listener
		super.EventChangeGrid(e);
		if (m_nSelectedRow != -1) {
			m_nSelectID = m_arrData.getItem(m_nSelectedRow).getID();
		}
	}
	
	/**
	 * Udalost na 2 klik mysi
	 *
	 * @param nCol sloupec
	 * @param nRow radek
	*/ 
	public void EventTwoClick(int nCol, int nRow) {
	}
	
	/** 
	 * Vytvor UniGrid s parametry
	 * 
	 * @param sSelectSQL SQL dotaz ktery zobrazime
	 * @param arrPopisy pole nadpisu sloupecku
	 * @return novy grid 
	*/
	public static McUniGrid CreateGrid(String sSelectSQL, String[] arrPopisy) {
		// rozsekame select
		String[] sParts = MeUniSQLItem.ParseSQL(sSelectSQL);
		
		// pokud nesedi pocet prvku v SELECTu a v popisu
		if( sParts.length == 0 || arrPopisy.length != sParts.length)
			throw new LException(McUniGrid.class, "Neodpovd seznam prvk a seznam popis!");
		
		// vytvorime GRID pro vykresleni
		McUniGrid grid = new McUniGrid();
		grid.m_arrData = MeUniSQLArray.CreateInstance(sSelectSQL);

		// nastavime popisy a jmeny sloupcu 
	  grid.m_arrColumn = new MeColumn[arrPopisy.length];
	  for (int i = 0; i < arrPopisy.length; i++) {
			grid.m_arrColumn[i] = MeColumn.createInstance(sParts[i], arrPopisy[i], 100);
	  }
	  // inicializujeme
	  grid.Inicialize(null);
    return grid; 
  }

  /**
   * Prida jednu polozku
   *  
   * @return radek nove polozky 
	*/ 
	public int AddItem() {
		throw new LException(this.getClass(), "Funkce PeUniGrid.AddItem() nen implementovna."); 
	}

	/**
	 * Smaze jednu polozku
	 *
	 * @param iItem smazana polozka
	 * @return prubeh funkce
	*/ 
	public boolean DeleteItem(MeItem iItem) {
		throw new LException(this.getClass(), "Funkce PeUniGrid.AddItem() nen implementovna."); 
	}

	/** 
	 * Vrati ID vybraneho prvku
	 * 
	 * @return ID vybraneho prvku 
	*/
  public int GetID() {
		return m_nSelectID;   	
  }

}
