package cz.luboss.medulla.common;

/**
	* Definice sloupce pro zobrazovaci tabulku
	*
	* @author LKC
*/
public class MeColumn implements java.io.Serializable {
	
	/** jmeno sloupce */ 
	protected String sName;
	/** popis sloupce */ 
	protected String sDesc;
	/** sirka sloupce */
	protected int nWidth = 0;

	/** Konstruktor */
	public MeColumn() {
	}

	/**
	   * Vytvareni sloupce s nastavenim hodnoty
	   *
	   * @param sName ID testu
	   * @param sDesc popis sloupce 
	   * @param nWidth sirka sloupce
	   * @return novy sloupec
	*/
	public static MeColumn createInstance(String sName, String sDesc, int nWidth) {
		MeColumn iCol = new MeColumn(); 
		iCol.SetName(sName);
		iCol.SetDesc(sDesc);
		iCol.SetWidth(nWidth);
		return iCol;
	}

	/**
	 * Nastavi jmeno 
	 * 
	 * @param sName jmeno sloupce
	 * @return prubeh funkce   
	*/
	public boolean SetName(String sName) {
		this.sName = sName;
		return true;
	}

	/**
	 * Vrati jmeno 
	 * 
	 * @return jmeno sloupce   
	*/
	public String GetName() {
		return sName;
	}

	/**
	 * Nastavi popis sloupce 
	 * 
	 * @param sDesc popis sloupce
	 * @return prubeh funkce   
	*/
	public boolean SetDesc(String sDesc) {
		this.sDesc = sDesc;
		return true;
	}

	/**
	 * Vrati popis sloupce
	 * 
	 * @return popis sloupce   
	*/
	public String GetDesc() {
		return sDesc;
	}

	/**
	 * Nastavi sirku sloupce v pixelech 
	 * 
	 * @param nWidth sirka sloupce v pixelech
	 * @return prubeh funkce   
	*/
	public boolean SetWidth(int nWidth) {
		this.nWidth = nWidth;
		return true;
	}

	/**
	 * Vrati sirku sloupce v pixelech
	 * 
	 * @return sirku sloupce v pixelech   
	*/
	public int GetWidth() {
		return nWidth;
	}

}
