
package cz.luboss.medulla.common;

import java.util.*;

// knihovna
import cz.luboss.lubosslib.LException;

// librarr
import cz.luboss.medulla.data.MeItem;

/**
 *  Transakcni masina pro Medulla
 *
 *@author    LKC
*/
public class MeTransact {

  /**  Mapa pro vsechny aktualni prvky */
	protected Map m_mpActualItem = new HashMap();

	/** Pole transakci */
	protected List m_arrTransact = new ArrayList();

	/**
	 *  Vytvori novy objet
	 *
	 * @return novy objekt
	 */
	public static MeTransact CreateInstance() {
		MeTransact transact = new MeTransact();
		return transact;
	}

  /**
	 * Vrati kolekci se vsemi prvky pro ulozeni
	 *
	 * @return popis funkce
	*/
	public Collection GetTransactionData() {
    return ((HashMap) m_arrTransact.get(m_arrTransact.size() - 1)).values();
	}
  
  /**
	 * Zjisti zda se jedna o posledni transakci
	 *
	 * @return popis funkce
	*/
	public boolean TransactionIsLast() {
    return m_arrTransact.size() == 1;
	}

  /**
	 * Zacne novou transakci
	 *
	 * @return prubeh funkce
	*/
	public boolean StartTransaction() {
    m_arrTransact.add(new HashMap());
		return true;
	}

	/**
	 * Vrati vsechny prvky zmenene v teto transakci do puvodniho stavu
	 *
	 * @return vrati prubeh fukce
	*/
	public boolean RollBack() {
    if (m_arrTransact.size() == 0) {
      throw new LException(this.getClass(), "Funkce RollBack() musi ukoncovat beh funkce StartTransaction()");
    }
    // vsechny objekty z transakce musi dotahnout z predchozich transakci nebo pokud v zadne transakci nejsou
    Map mapa = (Map) m_arrTransact.get(m_arrTransact.size() - 1);
    // odregistrujeme z transakce vsechny prvky
    for (Iterator iter = mapa.values().iterator(); iter.hasNext();) {
      UnRegister((MeItem) iter.next());
    }
    m_arrTransact.remove(m_arrTransact.size() - 1);
		return true;
	}

	/**
	 * Potvrdi vsechny provedene zmeny
	 *
	 * @return vrati prubeh fukce
	*/
	public boolean Commit() {
    if (m_arrTransact.size() == 0) {
      throw new LException(this.getClass(), "Funkce Commit() musi ukoncovat beh funkce StartTransaction()");
    }
    // pokud je neni posledni transakce
    if (m_arrTransact.size() != 1) {
      // vsechny objekty z transakce musi presunout do dalsi transakce
      Map mapa = (Map) m_arrTransact.get(m_arrTransact.size() - 1);
      Map mapaPrew = (Map) m_arrTransact.get(m_arrTransact.size() - 2);
      mapaPrew.putAll(mapa);
    }  
    m_arrTransact.remove(m_arrTransact.size() - 1);
		return true;
	}

	/**
	 * Zaregistruje objekt do transakce
	 *
	 * @return vrati prubeh fukce
	*/
	public boolean Register(MeItem item) {
    if (m_arrTransact.size() == 0) {
      throw new LException(this.getClass(), "Funkce Register() musi byt spustena v transakci");
    }
    // novy objekt neni mozne ulozit bez vygenerovaneho ID
    if (!item.isIDGenerate()) {
      throw new LException(this.getClass(), "Novy objekt neni mozne zaregistrovat bez vygenerovaneho ID");
    }
    // natahneme aktualni transakci
    Map mapa = (Map) m_arrTransact.get(m_arrTransact.size() - 1);
    // najdemem kod prvku
    String sKod = item.generateKod();
    // zkusime najit objekt, pokud existuje podame ho
    if (mapa.containsKey(sKod)) {
      item.setData((MeItem) mapa.get(sKod));
    // pokud neexistuje, zaregistrujeme
    } else {
    mapa.put(sKod, item);
    }
    // a zmeni v poli aktualnich prvku
    if (m_mpActualItem.containsKey(sKod)) {
      ((MeItem) m_mpActualItem.get(sKod)).setData(item);
    } else {
      m_mpActualItem.put(sKod, item);
    }
		return true;
	}

	/**
	 * Odregistruje objekt z transakce
	 *
	 * @return vrati prubeh fukce
	*/
	public boolean UnRegister(MeItem item) {
    if (m_arrTransact.size() == 0) {
      throw new LException(this.getClass(), "Funkce UnRegister() musi byt spustena v transakci");
    }
    String sKod = item.generateKod();
    // najdeme posledni vyskyt
    MeItem itemLast = null;
    // projedem vsechny transakce krome posledni a bude me hledat puvodni hodnotu
    for (int i = m_arrTransact.size() - 2; i >= 0; i--) {
      Map mapa = (Map) m_arrTransact.get(i);
      if (mapa.containsKey(item.generateKod())) {
        itemLast = (MeItem) mapa.get(sKod);
        break;
      }
    }
    // pokud jsme nic nenasli
    if (itemLast == null) {
      m_mpActualItem.remove(sKod);
    } else {
      ((MeItem) m_mpActualItem.get(sKod)).setData(itemLast);
    }
    return true;
	}

  /**
	 * Zjisti zda je v poli aktualnich prvku
	 *
	 * @return viz popis
	*/
	public boolean IsInActual(String sKod) {
    return m_mpActualItem.containsKey(sKod);
	}

  /**
	 * Vrati prvek primo z pole aktualnich prvku
	 *
	 * @return prvek nebo null, 
	*/
	public MeItem GetFromActual(String sKod) {
    return (MeItem) m_mpActualItem.get(sKod);
	}

  /**
	 * Vlozi prvek do pole aktualnich prvku, pokud tam jiz je, nastavi data podle aktualniho
	 *
	 * @return vrati false, pokud tento prvek jiz v poli je
	*/
	public boolean SetToActual(MeItem item) {
    String sKod = item.generateKod();
    if (m_mpActualItem.containsKey(sKod)) {
      item.setData((MeItem) m_mpActualItem.get(sKod));
      return false;
    }
    m_mpActualItem.put(sKod, item);
    return true;
	}
  
  /**
	 * Vypise celou transakci do textu
	 *
	 * @return vis popis
	*/
	public String toString() {
		String sData = "";
    // projedem vsechny transakce krome posledni a bude me hledat puvodni hodnotu
    for (int i = m_arrTransact.size() - 1; i <= 0; i--) {
      sData += "Transakce [" + i + "]\n";
      Map mapa = (Map) m_arrTransact.get(i);
      for (Iterator iter = mapa.keySet().iterator(); iter.hasNext();) {
        MeItem item = (MeItem) iter.next();
        sData += "  Item [" + item + "] " + item.getStatus() + "\n";
      }
    }
    return sData;
	}
  
}
