
package cz.luboss.medulla.common;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

// definice
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.factory.MeDataMachine;

/**
 *  Pracovn kontext - staticka trida zastresujici MeContext
 *
 *@author    LKC
 */
public class MedullaContext {
	/** Pracovni kontext */
	protected static MeContext m_PenContext = null;

	/**
	 * Vrati hodnotu konfigurace
	 *
   *@param sParam parametr configurace
	 *@return    viz popis
	 */
	public static String getConfParam(String sParam) {
		return m_PenContext.GetConf().getParam(sParam);
	}

	/**
	 *  Vrati uzivatelskou session
	 *
	 *@return    viz popis
	 */
	public static MeSession GetSession() {
		return m_PenContext.GetSession();
	}

	/**
	 *  Vrati ID uzivatelske session
	 *
	 *@return    viz popis
	 */
	public static int GetSessionID() {
		if (m_PenContext.GetSession() == null) {
			return -1;
		}
		return m_PenContext.GetSession().getID();
	}

	/**
	 *  Vrati text popisu podle jazyka uzivatele
	 *
	 *@param  sName  jmeno textu
	 *@return        viz popis
	 */
	public static String getRes(String sName) {
		return m_PenContext.GetRes(sName);
	}

	/**
	 *  Vrati masinu pro praci s daty
	 *
	 *@return    viz popis
	 */
	public static MeDataMachine GetMachine() {
		return (MeDataMachine) m_PenContext.GetMachine();
	}

  /**
	 * Zacne novou transakci
	 *
	 * @return prubeh funkce
	*/
	public static boolean StartTransaction() {
    return m_PenContext.StartTransaction();
  }
  
	/**
	 * Vrati vsechny prvky zmenene v teto transakci do puvodniho stavu
	 *
	 * @return vrati prubeh fukce
	*/
	public static boolean RollBack() {
    return m_PenContext.RollBack();
  }

	/**
	 * Potvrdi vsechny provedene zmeny
	 *
	 * @return vrati prubeh fukce
	*/
	public static boolean Commit() {
    return m_PenContext.Commit();
  }

	/**
	 * Zaregistruje objekt do transakce
	 *
	 * @return vrati prubeh fukce
	*/
	public static boolean Register(MeItem item) {
    return m_PenContext.Register(item);
  }

	/**
	 * Odregistruje objekt z transakce
	 *
	 * @return vrati prubeh fukce
	*/
	public static boolean UnRegister(MeItem item) {
    return m_PenContext.UnRegister(item);
  }
  
  /**
	 * Nahrajeme objekt
	 *
   * @param item objekt
   * @param nID ID objekt
	 * @return viz popis
	*/
  public static boolean LoadData(MeItem item, int nID) {
    return m_PenContext.LoadData(item, nID);
  }

  /**
	 * Nahrajeme pole objektu
	 *
   * @param array pole
   * @param iPodminka podlminka vyberu
	 * @return viz popis
	*/
  public static boolean LoadArray(MeArray array, MePodminka iPodminka) {
    return m_PenContext.LoadArray(array, iPodminka);
  }

  /**
	 * Smaze objekt
	 *
   * @param item objekt
   * @param nID ID objekt
	 * @return viz popis
	*/
  public static boolean DeleteData(MeItem item, int nID) {
    return m_PenContext.DeleteData(item, nID);
	}

  /**
	 * Nastavi soubor s konfiguraci Log4J
	 *
   * @param sFileLog jmeno konfiguracniho souboru
	*/
  public static void setConfLog4J(String sFileLog) {
    PropertyConfigurator.configure(sFileLog);
	}

  /**
	 * Zaloguje zpravu s objektem na uroven DEBUG
	 *
   * @param trida trida, pro jiz se loguje
   * @param sText ID objekt
	*/
  public static void logDebug(Class trida, String sText) {
    Logger.getLogger(trida).debug(sText);
	}

  /**
	 * Zaloguje zpravu s objektem na uroven INFO
	 *
   * @param trida trida, pro jiz se loguje
   * @param sText ID objekt
	*/
  public static void logInfo(Class trida, String sText) {
    Logger.getLogger(trida).info(sText);
	}

  /**
	 * Zaloguje zpravu s objektem na uroven WARN
	 *
   * @param trida trida, pro jiz nehoz se loguje
   * @param sText ID objekt
	*/
  public static void logWarn(Class trida, String sText) {
    Logger.getLogger(trida).warn(sText);
	}

  /**
	 * Zaloguje zpravu s objektem na uroven ERROR
	 *
   * @param trida trida, pro jiz nehoz se loguje
   * @param sText ID objekt
	*/
  public static void logError(Class trida, String sText) {
    Logger.getLogger(trida).error(sText);
	}
  
}
