 
package cz.luboss.medulla.data;

import java.util.ArrayList;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MePodminka;

/**
	* Zakladni trida pro vsechny pole polozek <p>
	*
	* @author LKC
*/
public abstract class MeArray extends ArrayList implements java.io.Serializable {

	/**
	  * Vlozi prvek na konec seznamu
	  *
	  * @return novy prvek
	*/
	public abstract MeItem addItem();

	/**
	  * Vlozi prvek na konec seznamu
	  *
	  * @param newComp novy prvek
	  * @return prubeh funkce
	*/
	public boolean addItem(MeItem newComp) {
		return this.add(newComp);
	}

	/**
	  * Vymaze prvek
	  *
	  * @param nRow poradi prvku ktery se bude mazat
	  * @return prubeh funkce
	*/
	public boolean removeItem(int nRow) {
		if (nRow < 0 || nRow >= this.getCount()) {
			return false;
    } else {
      // a zaroven 
			return this.remove(nRow) == null;
    }
	}

	/**
	  * Vymaze vsechny prvky
	  *
	  * @return prubeh funkce
	*/
	public boolean removeAll() {
    // vymazem ID prvku
    for (int i = 0; i < this.getCount(); i++) {
      this.getItem(i).delete();
    }
    // pomazem odkazy v poli
    this.clear();
		return true;
	}

	/**
	  * Vrati pocet prvku
	  *
	  * @return viz popis
	*/
	public int getCount() {
		return this.size();
	}

	/**
	  * Vrati prvek podle poradi
	  *
	  * @param nRow poradi prvku
	  * @return pozarovany prvek
	*/
	public MeItem getItem(int nRow) {
		if (nRow < 0 || nRow >= this.getCount()) {
			return null;
    }
		return (MeItem) this.get(nRow);
	}

	/**
	  * Vrati prvek podle ID
	  *
	  * @param  nID ID hledaneho prvku
	  * @return hledany prvek
	*/
	public MeItem getItemByID(int nID) {
		// projedem cele pole a pohledame 
		for (int i = 0; i < this.size(); i++) {
			if (((MeItem)this.get(i)).getID() == nID) {
				return (MeItem)this.get(i);
      }
		}
		// pokud nenajdem
		return null;
	}

	/**
	  * Vrati pocet radek na stranku
	  *
	  * @return viz popis
	*/
//	public int GetPageSize();

	/**
	  * Vrati pocet stranek
	  *
	  * @return viz popis
	*/
//	public int GetPageCount();
	
	/**
	  * Vrati iterator s urcitou casti celeho pole
	  *
	  * @param nPart cast pole 
	  * @return viz popis
	*/
//	public Iterator GetPage(nPart);

  /** 
	 * Nastavi vsem prvkum v poli stejny status
	 *
	 * @param nStatus novy status
	*/
	public void setStatus(int nStatus) {
    for (int i = 0; i < this.getCount(); i++) {
      this.getItem(i).setStatus(nStatus);
    }
	}

  /** 
	 * Nahraje pole
	 *
	 * @param podminka podminka pro nacteni
	 * @return prubeh metody  
	*/
	public boolean loadArray(MePodminka podminka) {
		return MedullaContext.LoadArray(this, podminka);
	}
 
}
