
package cz.luboss.medulla.data;

import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.types.*;

/**
 * Univerzalni elemnet pro nacitani z SQL
 * 
 * @author LKC
*/
public class MeUniSQLItem extends MeItem {

  /** Pole parametru */
  MeField[] m_arrParam;

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

  /** Pomocny select */
	protected String m_sSQLQuery;

	/**
	  * Rozparsuje SELECT
	  *
	  * @return viz popis
	*/
	public static String[] ParseSQL(String sSQLQuery) {
		String[] sParts = sSQLQuery.split("FROM");
		if (sParts.length != 2 || !sParts[0].trim().startsWith("SELECT"))
			throw new LException(MeUniSQLItem.class, "Prikaz SELECT [" + sSQLQuery + "] je spatny!\n" 
        + "Musi byt zachovan format SELECT po01, po02, po03 FROM ... PRESNE I S MEZERAMA!!!"); 
		sParts = sParts[0].substring(6).trim().split(", "); 
		return sParts;
	}

	/**
	  * Vytvori novy prvek ze SQL dotazu
	  *
	  * @return novy prvek
	*/
	public static MeUniSQLItem CreateInstance(String sSQLQuery) {
		MeUniSQLItem newItem = new MeUniSQLItem();
		// nastavime hodnoty 
		newItem.m_sSQLQuery = sSQLQuery;
		// naplnime pole parametru
		newItem.LoadParamFromSQL();
		return newItem;
	}

	/**
	 * Naplni pro dany prvek jeho popis 
	 * 
	 * @return prubeh metody
	*/
	public boolean LoadParamFromSQL() {
		// parsnem SQL
		String[] sParts = MeUniSQLItem.ParseSQL(m_sSQLQuery); 
		// naplnime pole parametru
		this.m_arrParam = new MeField[sParts.length];
		// prvni prvek je ID
		this.m_arrParam[0] = MeFieldINT.createInstance(sParts[0], MeDefine.DEF_NEW_ITEM_ID, false);
		for(int i = 1; i < this.m_arrParam.length; i++)
			this.m_arrParam[i] = MeFieldSTRING.createInstance(sParts[i], "", false);
		return true;
	}

////////////////////////////////////////////////////////////////////////////////
// Dalsi funkce jsou nutne prepsane pro MeItem
   
	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
  public int getFieldID() {
    throw new LException(this.getClass(), "Pro tridu MeUniSQLItem neni definovana funkce GetFieldID()");
  }

  /**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
  public int getID() {
    if (m_arrParam.length == 0) {
      throw new LException(this.getClass(), "Objekt tridy MeUniSQLItem musi mit prvni parametr MeFieldINT jako ID"); 
    }
    // vratime hodnotu prvniho prvku
    return m_arrParam[0].GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
  public String getNameID() {
		throw new LException(this.getClass(), "Pro tridu MeUniSQLItem neni definovana funkce getNameID()"); 
  }
  
	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
  public boolean setData(MeItem zdroj) {
		throw new LException(this.getClass(), "Pro tridu MeUniSQLItem neni definovana funkce setData()"); 
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
  public int getParamCount() {
		return m_arrParam.length;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
  public MeField getParam(int nRow) {
    if (nRow < 0 || nRow > m_arrParam.length - 1) {
      throw new LException(this.getClass(), "Nepletne poradi parametru"); 
    }
    return m_arrParam[nRow];
  }

  /**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
  public MeField getParam(String sName) {
    for (int i = 0; i < m_arrParam.length; i++) {
      if (m_arrParam[i].GetName().equals(sName)) {
        return m_arrParam[i];
      }
    }
    return null;
  }
  
  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
  public String generateKod() {
		throw new LException(this.getClass(), "Pro tridu MeUniSQLItem neni definovana funkce generateKod()"); 
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

  /**
	  * Nahraje objekt podle podminky
	  *
	  * @param podminka podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean load(int nID) {
		throw new LException(this.getClass(), "Pro tridu MeUniSQLItem neni definovana funkce load()"); 
	}
    
	/**
	  * Vymaze prvek
	  *
	  * @return prubeh metody
	*/
	public boolean delete() {
		throw new LException(this.getClass(), "Pro tridu MeUniSQLItem neni definovana funkce delete()"); 
	}
  
}
