package cz.luboss.medulla.factory;

// knihovna
import cz.luboss.lubosslib.LConnection;

// definice
import cz.luboss.medulla.factory.MeConnectSQL;

/**
	* Pripojeni k datovemu zdroji SQL
	*
	* @author LKC
*/
public class MeConnectSQL implements MeConnect {

	/** Connector do databaze */
	protected LConnection m_dtConnectDB;
	 
	/** Jmeno driveru SQL*/
	protected String m_sDriverName; 
	/** Connect string */
	protected String m_sConnectString; 
	/** Jmeno usera*/
	protected String m_sUser; 
	/** Heslo */
	protected String m_sPass; 

	/** 
	 * Vytvori novy objet 
	 * 
	 * @return viz popis
	*/
	public static MeConnectSQL CreateInstance(String sDriverName, String sConnectString, String sUser, String sPass) {
		MeConnectSQL obj = new MeConnectSQL();
		obj.m_sDriverName = sDriverName;
		obj.m_sConnectString = sConnectString;
		obj.m_sUser = sUser;
		obj.m_sPass = sPass;
		return obj;  
	}

	/** 
	 * Vrati connector do databaze 
	 * 
	 * @return connector
	*/
	public LConnection GetDB() {
		if (m_dtConnectDB == null || m_dtConnectDB.isClosed()) {
			m_dtConnectDB = LConnection.Create(m_sDriverName, m_sConnectString, m_sUser, m_sPass);
		}
		return m_dtConnectDB; 
	}  

}
