
package cz.luboss.medulla.factory;

import java.util.Collection;

// definice
import cz.luboss.medulla.common.MePodminka;
import cz.luboss.medulla.common.MeDataTest;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.data.MeSession;

/**
 *  Interface tovaren pro persistenci objektu
 *
 *@author    LKC
 */
public interface MeDataMachine {

	/**
	 *  Vrati configuraci pripojeni
	 *
	 *@return    vis popis
	 */
	public MeConnect GetConnect();

	/**
	 *  Nastavi configuraci pripojeni
	 *
	 *@param  dbConnect  konfigurace pripojeni
	 *@return            prubeh funkce
	*/
	public boolean SetConnect(MeConnect dbConnect);

	/**
	 *  Otestuje rozhrani
	 *
	 *@param  testing  testovaci objekt
	 *@return          testovaci objekt
	 */
	public MeDataTest sendTest(MeDataTest testing);

	/**
	 *  Zaloguje uzivatele a vrati jeho session
	 *
	 *@param  sLogin     login uzivatele
	 *@param  sPassword  heslo uzivatele
	 *@return            vytvorena Session
	 */
	public MeSession LoadSession(String sLogin, String sPassword);

	/**
	 *  Vrati vsechny aktualni session
	 *
	 *@return    vis popis
	 */
	public MeArray GetActualSessions();


	/**
	 *  Zjisti zda je session platna
	 *
	 *@param  nSessionID  ID session, ktera se testuje
	 *@return             vis popis
	 */
	public boolean IsValidSession(int nSessionID);

	/**
	 *  Nahraje data do objektu
	 *
	 *@param  nSessionID  Session
   *@param  item prvek do nehoz se ma nahravat
	 *@param  nID ID prvku pro nacteni
	 *@return nacteny prvek
	*/
	public boolean LoadData(int nSessionID, MeItem item, int nID);

  /**
	 *  Nahraje data do pole
	 *
	 *@param  nSessionID  Session
	 *@param  arrayItem   pole do ktereho nahravame
	 *@param  podminka    vyberova podminka
	 *@return             pole objektu, ktery nacitame
	*/
	public boolean LoadArray(int nSessionID, MeArray arrayItem, MePodminka podminka);

	/**
	 *  Ulozi data transakce
	 *
	 *@param  nSessionID  Session
	 *@param  arrTransData data transakce, kterou ukladame
	 *@return             prubeh funkce
	 */
	public boolean SaveTrans(int nSessionID, Collection arrTransData);

	/**
	 *  Prideli ID novemu prvku
	 *
	 *@param  nSessionID  Session
	 *@param  item prvek pro nehoz mame vygenerovat nove ID
	 *@return nove ID
	*/
	public int AddSequenceID(int nSessionID, MeItem item);

}
