
package cz.luboss.medulla.factory;

import java.util.Collection;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDataTest;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.common.MePodminka;
import cz.luboss.medulla.common.MeUtils;
import cz.luboss.medulla.data.*;

/**
 *  Tovarna pro persistenci objektu pres RMI
 *
 *@author    LKC
 */
public abstract class MeDataMachineRMI implements MeDataMachine, MedullaRMI {

  /**
	 *  Connect k datum
	 */
	protected MeConnectRMI m_dtConnectRMI;

///////////////////////////////////////////////////////////////////////
//	 Implementace rozhrani MeDataMachine

	/**
	 *  Nastav configuraci pipojen
	 *
	 *@param  dtConnect  konfigurace pripojeni
	 *@return            prubeh funkce
	 */
	public boolean SetConnect(MeConnect dtConnect) {
		m_dtConnectRMI = (MeConnectRMI) dtConnect;
		return true;
	}

	/**
	 *  Vrati configuraci pripojeni
	 *
	 *@return    vis popis
	 */
	public MeConnect GetConnect() {
		return this.m_dtConnectRMI;
	}

//////////////////////////////////////////////////////////////////////
// Implementace rozhrani MeDataMachine a MedullaRMI

  /**
	 *  Otestuje rozhrani RMI
	 *
	 *@param  message  testovaci objekt
	 *@return          testovaci objekt
	 */
	public MeDataTest sendTest(MeDataTest message) {
		try {
			return m_dtConnectRMI.GeRMI().sendTest(message);
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "Chyba pri spousteni RMI testu");
		}
	}


	/**
	 *  Zaloguje uzivatele a vrati jeho session
	 *
	 *@param  sLogin     login uzivatele
	 *@param  sPassword  heslo uzivatele
	 *@return            vytvorena Session
	 */
	public MeSession LoadSession(String sLogin, String sPassword) {
    // zalogujeme DEBBUG
    MedullaContext.logDebug(this.getClass(), "LoadSession RMI [" + sLogin + "]");

    try {
			return m_dtConnectRMI.GeRMI().LoadSession(sLogin, sPassword);
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "LoadSession [" + sLogin + "] Error");
		}
	}


	/**
	 *  Zjisti zda je session platna
	 *
	 *@param  nSessionID  ID session, ktera se testuje
	 *@return             vis popis
	 */
	public boolean IsValidSession(int nSessionID) {
		try {
			return m_dtConnectRMI.GeRMI().IsValidSession(nSessionID);
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "IsValidSession [" + nSessionID + "] Error");
    }
	}

	/**
	 *  Vrati vsechny aktualni session
	 *
	 *@return    vis popis
	 */
	public MeArray GetActualSessions() {
		try {
			return m_dtConnectRMI.GeRMI().GetActualSessions();
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "GetActualSessions Error");
		}
	}

	/**
	 *  Nahraje data do objektu
	 *
	 *@param  nSessionID  Session
   *@param  item prvek do nehoz se ma nahravat
	 *@param  nID ID prvku pro nacteni
	 *@return  prubeh metody
	*/
	public boolean LoadData(int nSessionID, MeItem item, int nID) {
    // zalogujeme DEBBUG
    MedullaContext.logDebug(this.getClass(), "S[" + nSessionID + "] Load Item " + MeUtils.separeName(item.getClass())
      + " pro ID [" + nID + "].");

    MeItem loadRMI = LoadDataRMI(nSessionID, item, nID);
    if (loadRMI == null) {
      return false;
    }
    return item.setData(loadRMI);
	}

  /**
	 *  Nahraje data do pole
	 *
	 *@param  nSessionID  Session
	 *@param  arrayItem   pole do ktereho nahravame
	 *@param  podminka    vyberova podminka
	 *@return  prubeh metody
	*/
	public boolean LoadArray(int nSessionID, MeArray arrayItem, MePodminka podminka) {
    // zalogujeme DEBBUG
    MedullaContext.logDebug(this.getClass(), "S[" + nSessionID + "] Load Array " 
      + MeUtils.separeName(arrayItem.getClass()) + " pro podminkou [" 
      + (podminka == null ? "null" : podminka.GetSQLQuery()) + "].");

    MeArray arrayRMI = LoadArrayRMI(nSessionID, arrayItem, podminka);
		if (arrayRMI == null) {
			return false;
		}
		arrayItem.clear();
		arrayItem.addAll(arrayRMI);
		return true;
	}

	/**
	 *  Ulozi data transakce
	 *
	 *@param  nSessionID  Session
	 *@param  arrTransData data transakce, kterou ukladame
	 *@return             prubeh funkce
	*/
	public boolean SaveTrans(int nSessionID, Collection arrTransData) {
    // zalogujeme DEBBUG
    MedullaContext.logDebug(this.getClass(), "S[" + nSessionID + "] Transakce s poctem " + arrTransData.size() 
      + " bude ulozena.");

    try {
			return m_dtConnectRMI.GeRMI().SaveTrans(nSessionID, arrTransData);
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "S[" + nSessionID + "] SaveTrans RMI Error", e);
		}
	}

	/**
	 *  Prideli ID novemu prvku
	 *
	 *@param  nSessionID  Session
	 *@param  item prvek pro nehoz mame vygenerovat nove ID
	 *@return nove ID
	*/
	public int AddSequenceID(int nSessionID, MeItem item) {
    // zalogujeme DEBBUG
    MedullaContext.logDebug(this.getClass(), "S[" + nSessionID + "] Generovani ID pro " 
      + MeUtils.separeName(item.getClass()));

    try {
			return m_dtConnectRMI.GeRMI().AddSequenceID(nSessionID, item);
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "S[" + nSessionID + "] AddSequenceID " 
        + MeUtils.separeName(item.getClass()) + " Error", e);
		}
  }

//////////////////////////////////////////////////////////////////////
// Implementace rozhrani MedullaRMI

  /**
	 *  Nahraje data do objektu
	 *
	 *@param  nSessionID  Session
   *@param  item prvek do nehoz se ma nahravat
	 *@param  nID ID prvku pro nacteni
	 *@return             nacteny prvek
	*/
	public MeItem LoadDataRMI(int nSessionID, MeItem item, int nID) {
		try {
      return m_dtConnectRMI.GeRMI().LoadDataRMI(nSessionID, item, nID);
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "S[" + nSessionID + "] LoadDataRMI Error " 
        + MeUtils.separeName(item.getClass()) + ", ID [" + nID + "]", e);
		}
	}

  /**
	 *  Nahraje data do pole
	 *
	 *@param  nSessionID  Session
	 *@param  arrayItem   pole do ktereho nahravame
	 *@param  podminka    vyberova podminka
	 *@return             pole objektu, ktery nacitame
	*/
	public MeArray LoadArrayRMI(int nSessionID, MeArray arrayItem, MePodminka podminka) {
		try {
			return m_dtConnectRMI.GeRMI().LoadArrayRMI(nSessionID, arrayItem, podminka);
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "S[" + nSessionID + "] Load Array " 
        + MeUtils.separeName(arrayItem.getClass()) + " pro podminkou [" 
        + (podminka == null ? "null" : podminka.GetSQLQuery()) + "].");
		}
	}

}
