
package cz.luboss.medulla.factory;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.SQLException;
import java.util.*;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.types.*;

/**
 *  Tovarna pro persistenci objektu pres SQL
 *
 *@author    LKC
 */
public abstract class MeDataMachineSQL implements MeDataMachine {

  /** Objekt s parametry SQL */
  MeParamSQL m_iParamSQL;
  
  /** Connect k datum */
	protected MeConnectSQL m_dtConnectSQL;

	/**
	 *  Nastav configuraci pipojen
	 *
	 *@param  dbConnect  konfigurace pripojeni
	 *@return            prubeh funkce
	 */
	public boolean SetConnect(MeConnect dbConnect) {
		m_dtConnectSQL = (MeConnectSQL) dbConnect;
		return true;
	}

	/**
	 *  Vrati configuraci pripojeni
	 *
	 *@return    vis popis
	 */
	public MeConnect GetConnect() {
		return this.m_dtConnectSQL;
	}

	/**
	 *  Vrati configuraci pripojeni
	 *
	 *@return    vis popis
	 */
	public void setParamSQL(MeParamSQL param) {
		this.m_iParamSQL = param;
	}
  
	/**
	 *  Vrati configuraci pripojeni
	 *
	 *@return    vis popis
	 */
	public MeParamSQL getParamSQL() {
		return this.m_iParamSQL;
	}
 
  /**
	 *  Otestuje rozhrani
	 *
	 *@param  message  testovaci objekt
	 *@return          testovaci objekt
	 */
	public MeDataTest sendTest(MeDataTest message) {
		// naplnime
		String sSQLQuery = "SELECT CURDATE() as test ";
		String sRet = "";
		try {
			Statement stm = m_dtConnectSQL.GetDB().GetConect().createStatement();
      
      // zalogujeme DEBBUG
      MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);
      
      ResultSet rs = stm.executeQuery(sSQLQuery);
			// naplnime objekt
			if (rs.next()) {
				sRet = rs.getString("test");
			}
			rs.close();
			stm.close();
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "Chyba pri spousteni SQL testu");
    }
		return new MeDataTest(27, sRet);
	}


	/**
	 *  Vrati vsechny aktualni session
	 *
	 *@return    vis popis
	 */
	public MeArray GetActualSessions() {
		// pro SQL vratime prazdny list
		return null;
	}

  /**
	 *  Zjisti zda je session platna
	 *
	 *@param  nSessionID  ID session, ktera se testuje
	 *@return             vis popis
	 */
	public boolean IsValidSession(int nSessionID) {
		// pro server je session vzdy platna
		return true;
	}

	/**
	 *  Nahraje data do objektu
	 *
	 *@param  nSessionID  Session
	 *@param  item        objekt, ktery nacitame
	 *@param  nID ID nove prvku
	 *@return             nacteny prvek
	 */
	public boolean LoadData(int nSessionID, MeItem item, int nID) {
    // String sSQLQuery,
		String sSQLQuery = this.getParamSQL().getSQL_SELECT(item);
    
		try {
			sSQLQuery += " AND " + item.getNameID() + " = " + nID;
			// naplnime
			Statement stm = m_dtConnectSQL.GetDB().GetConect().createStatement();
      
      // zalogujeme DEBBUG
      MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);

      ResultSet rs = stm.executeQuery(sSQLQuery);
			// naplnime objekt
			if (rs.next()) {
				LoadFromRes(item, rs);
			} else {
        return false;
      }
			rs.close();
			stm.close();
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "LoadData SQL Error [" + sSQLQuery + "]", e);
		}
		return true;
	}

	/**
	 *  Nahraje data do pole
	 *
	 *@param  nSessionID  Session
	 *@param  array       pole objektu, ktery nacitame
	 *@param  podminka    vyberova podminka
	 *@return             prubeh funkce
	 */
	public boolean LoadArray(int nSessionID, MeArray array, MePodminka podminka) {
    String sSQLQuery = this.getParamSQL().getSQL_SELECT(array);
		try {
			// nejdriv pole vymazeme
			array.clear();
			// pridame podminku
			if (podminka != null) {
				sSQLQuery += " AND " + podminka.GetSQLQuery();
			}
			// naplnime
			Statement stm = m_dtConnectSQL.GetDB().GetConect().createStatement();
      
      // zalogujeme DEBBUG
      MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);

			ResultSet rs = stm.executeQuery(sSQLQuery);
			// naplnime objekt
			while (rs.next()) {
				// vytvorime novy prvek pole
				MeItem newItem = array.addItem();
				LoadFromRes(newItem, rs);
			}
			rs.close();
			stm.close();
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "LoadArray SQL Error [" + sSQLQuery + "]", e);
		}
		return true;
	}

	/**
	 * Ulozi data transakce
	 *
	 * @param  nSessionID  Session
	 * @param  arrTransData data transakce, kterou ukladame
	 * @return prubeh funkce
  */
	public boolean SaveTrans(int nSessionID, Collection arrTransData) {
    for (Iterator iter = arrTransData.iterator(); iter.hasNext();) {
      MeItem item = (MeItem) iter.next();
      String sTable = this.getParamSQL().getSQL_INSERT(item);
      String sSQLQuery = "EMPTY";
      try {
        boolean bFirst = true;
        // pokud insertujeme
        if (item.isNew()) {
          // a pak ulozime
          sSQLQuery = "INSERT INTO " + sTable + "(";
          String sSQLQueryPom = ") VALUES(";
          for (int i = 0; i < item.getParamCount(); i++) {
            sSQLQuery += (bFirst ? "" : ", ") + item.getParam(i).GetName();
            sSQLQueryPom += (bFirst ? "" : ", ") + item.getParam(i).GetSQLString();
            bFirst = false;
          }
          sSQLQuery += sSQLQueryPom + ")";
        // pokud mazeme          
        } else if (item.isDeleted()) {
          sSQLQuery = "DELETE FROM " + sTable + " WHERE " + item.getNameID() + " = " + item.getID();
        // nebo Updatujeme
        } else {
          sSQLQuery = "UPDATE  " + sTable + " SET ";
          for (int i = 0; i < item.getParamCount(); i++) {
            sSQLQuery += (bFirst ? "" : ", ") + item.getParam(i).GetName() + " = " + item.getParam(i).GetSQLString();
            bFirst = false;
          }
          sSQLQuery += " WHERE " + item.getParam(item.getFieldID()).GetName() + " = " + item.getID();
        }
      
        // zalogujeme DEBBUG
        MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);

        // a ulozime
        m_dtConnectSQL.GetDB().GetConect().createStatement().executeUpdate(sSQLQuery);
      }
      catch (Exception e) {
        throw new cz.luboss.lubosslib.LException(this.getClass(), "SaveTrans SQL Error [" + sSQLQuery + "]", e);
      }
    }
		return true;
	}

	/**
	 *  Prideli ID novemu prvku
	 *
	 *@param  nSessionID  Session
	 *@param  item prvek pro nehoz mame vygenerovat nove ID
	 *@return nove ID
	*/
	public int AddSequenceID(int nSessionID, MeItem item) {
    int nID = 0;
    String sSQLQuery = "";
    // nejdriv nactem nove ID
    try {
      String sInsertTable = this.getParamSQL().getSQL_INSERT(item);
      sSQLQuery = "SELECT count(*), MAX(sqcounter)+1 from " + MedullaContext.getConfParam(MeConfig.SEQUENCE_TABLE)
        + " where sqname = '" + sInsertTable + "'";
      Statement stm = m_dtConnectSQL.GetDB().GetConect().createStatement();
      
      // zalogujeme DEBBUG
      MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);

      ResultSet rs = stm.executeQuery(sSQLQuery);
      // pokud jsme neco nasli, UPDATE
      if (rs.next() && rs.getInt("count(*)") != 0) {
        nID = rs.getInt("MAX(sqcounter)+1");
        sSQLQuery = "UPDATE " + MedullaContext.getConfParam(MeConfig.SEQUENCE_TABLE) + " SET sqcounter = " + nID
          + " where sqname = '" + sInsertTable + "'";
      // jinak INSERT
      } else {
        sSQLQuery = "INSERT INTO " + MedullaContext.getConfParam(MeConfig.SEQUENCE_TABLE) + "(sqname, sqcounter)"
          + " VALUES ('" + sInsertTable + "', 0)";
      }
      rs.close();
      stm.close();
      
      // zalogujeme DEBBUG
      MedullaContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);

      // a ulozime
      m_dtConnectSQL.GetDB().GetConect().createStatement().executeUpdate(sSQLQuery);
    }
    catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "AddSequenceID Error [" + sSQLQuery + "]", e);
    }
    return nID;
	}

	/**
	 *  Nahraje data do objektu z recordsetu
	 *
	 *@param  item  objekt do ktereho se data nahravaji
	 *@param  rs    recordset ze ktereho se data nahravaji
	 */
	private static void LoadFromRes(MeItem item, ResultSet rs) {
		try {
			// stahneme ostatni data
			for (int i = 0; i < item.getParamCount(); i++) {
				switch (item.getParam(i).GetType()) {
					case MeField.INTEGER:
						((MeFieldINT) item.getParam(i)).SetInt(rs.getInt(i + 1));
						break;
					case MeField.FLOAT:
						((MeFieldFLOAT) item.getParam(i)).SetFloat(rs.getFloat(i + 1));
						break;
					case MeField.DATE:
						((MeFieldDATE) item.getParam(i)).SetDate(rs.getDate(i + 1));
						break;
					case MeField.STRING:
						((MeFieldSTRING) item.getParam(i)).SetString(rs.getString(i + 1));
						break;
					case MeField.REF:
						((MeFieldREF) item.getParam(i)).SetRefID(rs.getInt(i + 1));
						break;
				}
			}
		}
		catch (SQLException e) {
      throw new cz.luboss.lubosslib.LException(MeDataMachineSQL.class, "LoadFromRes ", e);
		}
	}

}
