
package cz.luboss.medulla.types;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

// knihovna
import cz.luboss.lubosslib.LException;

/**
	* Datovy typ Datum
	*
	* @author LKC
*/
public class MeFieldDATE extends MeField{
	
	/** Parametr */
	protected Date tValue = new Date();
	/** Formatovac */ 
	protected SimpleDateFormat formatDate = new SimpleDateFormat("yyyyMMddHHmmss"); 

	/** Konstruktor */
	protected MeFieldDATE() {
	}

	/**
	 * Vytvari novy objekt i s hodnotami
	 *
	 * @param sName jmeno polozky
	 * @param tParam hodnota parametru
	 * @param bCanEdit signal, zda se muze editovat
	 * @return novy objekt
	*/
	public static MeFieldDATE createInstance(String sName, Date tParam, boolean bCanEdit) {
		MeFieldDATE field = new MeFieldDATE();
		field.m_sName = sName;
		field.tValue = tParam;
		field.m_bCanEdit = bCanEdit;
		return field;
	}

	/**
	 * Vrati ID typu
	 *
	 * @return ID typu
	*/
	public int GetType() {
		return MeField.DATE;
	}

	/**
	 * Nastavi hodnotu parametru
	 *
	 * @param tParam hodnota parametru
	 * @return prubeh funkce
	*/
	public boolean SetDate(Date tParam) {
		tValue = tParam;
		return true;
	}

	/**
	 * Vrati hodnotu parametru
	 *
	 * @return hodnota parametru
	*/
	public Date GetDate() {
		return tValue;
	}

	/**
	 * Nastavi hodnotu parametru z retezce 
	 *
	 * @param sParam retezec s datumem ve formatu <b>yyyyMMddHHmmss</b>
	 * @return prubeh funkce
	*/
	public boolean SetString(String sParam) {
		return SetString(sParam, "yyyyMMddHHmmss");
	}

	/**
	 * Nastavi hodnotu parametru z retezce 
	 *
	 * @param sParam retezec s datumem
	 * @param sFormat format datumu
	 * @return prubeh funkce
	*/
	public boolean SetString(String sParam, String sFormat) {
		try {
			formatDate = new SimpleDateFormat(sFormat);
			ParsePosition pos = new ParsePosition(0);
			tValue = formatDate.parse(sParam, pos);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	/**
	 * Vrati hodnotu jako String
	 *
	 * @return viz popis
	*/
	public String GetString() {
		return GetFormatString("dd.MM.yyyy HH:mm:ss");
	}
	
	/**
	 * Vrati hodnotu jako String - pro SQL
	 *
	 * @return viz popis
	*/
	public String GetSQLString() {
		return "'" + GetFormatString("yyyy-MM-dd HH:mm:ss") + "'";
	}

	/**
	 * Vrati hodnotu jako String - naformatovanou
	 *
	 * @param sFormat formatovaci retezec
	 * @return viz popis
	*/
	public String GetFormatString(String sFormat) {
		if (tValue == null)
			return "";
		formatDate = new SimpleDateFormat(sFormat);
		return formatDate.format(tValue);
	}

	/**
	 * Vrati hodnotu jako cele cislo
	 *
	 * @return cele cislo
	*/
	public int GetInt() {
		throw new LException(this.getClass(), "Typ DATE neni mozne vratit jako Integer.");
	}

}
