
package cz.luboss.medulla.types;

/**
	* Datovy typ cele cislo
	*
	* @author LKC
*/
public class MeFieldINT extends MeField{
	
	/** parametr */
	protected int nValue = 0; 

	/** Konstruktor */
	protected MeFieldINT() {
	}

	/**
	 * Vytvari novy objekt i s hodnotami
	 *
	 * @param sName jmeno polozky
	 * @param iParam hodnota parametru
	 * @param bCanEdit signal, zda se muze editovat
	 * @return novy objekt
	*/
	public static MeFieldINT createInstance(String sName, int iParam, boolean bCanEdit) {
		MeFieldINT field = new MeFieldINT();
		field.m_sName = sName;
		field.nValue = iParam;
		field.m_bCanEdit = bCanEdit;
		return field;
	}

	/**
	 * Vrati ID typu
	 *
	 * @return ID typu
	*/
	public int GetType() {
		return MeField.INTEGER;
	}

	/**
	 * Nastavi hodnotu parametru
	 *
	 * @param nParam parametr
	 * @return prubeh funkce
	*/
	public boolean SetInt(int nParam) {
		nValue = nParam;
		return true;
	}

	/**
	 * Vrati hodnotu jako cele cislo
	 *
	 * @return cele cislo
	*/
	public int GetInt() {
		return nValue;
	}

	/**
	 * Nastavi hodnotu z retezce
	 *
	 * @param sParam retezec
	 * @return prubeh funkce
	*/
	public boolean SetString(String sParam) {
		try {
			nValue = Integer.parseInt(sParam);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	/**
	 * Vrati hodnotu jako String
	 *
	 * @return viz popis
	*/
	public String GetString() {
		return String.valueOf(nValue);
	}
	
	/**
	 * Vrati hodnotu jako String - pro SQL
	 *
	 * @return viz popis
	*/
	public String GetSQLString() {
		return String.valueOf(nValue);
	}

	/**
	 * Vrati hodnotu jako String - naformatovanou
	 *
	 * @param sFormat formatovaci retezec
	 * @return viz popis
	*/
	public String GetFormatString(String sFormat) {
		return String.valueOf(nValue);
	}

}
