
package cz.luboss.medulla.types;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.MeItem;

/**
	* Datovy typ reference - odkaz na jiny objekt
	*
	* @author LKC
*/
public class MeFieldREF extends MeField {

	/** parametr typu reference na jiny objekt */
	protected MeItem m_iValue;
	/** jeho trida */
	protected Class m_clValue;
	/** jmeno polozky pro zobrazeni */
	protected String m_sFieldName;
	/** ID objektu */
	protected int m_nID = MeDefine.DEF_NEW_ITEM_ID;

	/**
	 * Vytvari novy objekt i s hodnotami
	 *
	 * @param sName jmeno polozky
	 * @param clItem trida objektu, na ktery je odkazovano
	 * @param sFieldName jmeno polozky, ktera se bude zobrazovat ve funkci GetString()
	 * @param nID ID objektu, na ktery je odkazovano
	 * @param bCanEdit signal, zda se muze editovat
	 * @return novy objekt
  */
	public static MeFieldREF createInstance(String sName, Class clItem, String sFieldName, int nID, boolean bCanEdit) {
		// otestujem zda zadan trida je instanci MeItem
/*		if (!( clItem.isAssignableFrom(MeItem.class))) {
			throw new LException("Typ reference muze byt nastaven pouze na objekt typu MeItem");	
		}
*/		
		MeFieldREF field = new MeFieldREF();
		field.m_sName = sName;
		field.m_clValue = clItem;
		field.m_sFieldName = sFieldName;
		field.m_nID = nID;
		field.m_bCanEdit = bCanEdit;
    return field;
	}

	/**
	 * Vytvari novy objekt i s hodnotami
	 *
	 * @param sName jmeno polozky
	 * @param iItem objekt na ktery se odkazuje
	 * @param sFieldName jmeno polozky, ktera se bude zobrazovat ve funkci GetString()
	 * @param bCanEdit signal, zda se muze editovat
	 * @return novy objekt
  */
	public static MeFieldREF createInstance(String sName, MeItem iItem, String sFieldName, boolean bCanEdit) {
		MeFieldREF field = new MeFieldREF();
		field.m_sName = sName;
    field.m_sFieldName = sFieldName;
		field.m_iValue = iItem;
		field.m_bCanEdit = bCanEdit;
		return field;
	}

	/**
	 * Nastavi jmeno polozky, ktera se bude zobrazovat ve funkci GetString()
	 *
	 * @param sFieldName jmeno polozky
	*/
	public void SetFieldName(String sFieldName) {
		this.m_sFieldName = sFieldName;
	}

	/**
	 * Vrati ID typu
	 *
	 * @return ID typu
	*/
	public int GetType() {
		return MeField.REF;
	}

	/**
	 * Nastavi hodnotu refernce
	 *
	 * @param item objekt
	 * @return prubeh funkce
	*/
	public boolean SetRef(MeItem item) {
		this.m_clValue = item.getClass();
		this.m_iValue = item;
		this.m_nID = item.getID();
		return true;
	}

	/** 
	 * Vrati objekt, pokud neni natazen, dotahne se 
	 * 
	 * @return viz popis 
	*/
	public MeItem GetRef() {
		// pokud objekt nebyl vytvoren nebo neodpovida jeho ID zadanemu ID parametru 
		if (m_iValue == null || m_nID != m_iValue.getID()) {
			try {
				m_iValue = (MeItem) m_clValue.getMethod("createInstance", null).invoke(m_clValue, null);
				m_iValue.load(m_nID);
			} catch (Exception e) {
  			throw new LException(MeFieldREF.class, "Load MeItem [" +  MeUtils.separeName(m_clValue) + "][" + m_nID
          + "]to MeFieladREF Error");
			}
		}
		return m_iValue;
	}

	/** 
	 * Nastav ID objektu, na ktery je odkazovano 
	 * 
	 * @param nID ID objektu
	 * @return prubeh funkce 
	*/
	public boolean SetRefID(int nID) {
		// natavime ID prvku
		m_nID = nID;
		return true;
	}

	/** Vrt ID objektu, na ktery je odkazovano */
	public int GetRefID() {
		return m_nID;
	}

	/**
	 * Nastavi hodnotu z retezce
	 *
	 * @param sParam retezec
	 * @return prubeh funkce
	*/
	public boolean SetString(String sParam) {
  	throw new LException(MeFieldREF.class, "Typ reference nemuze byt nastaven ze Stringu");
	}

	/**
	 * Vrati hodnotu jako String
	 *
	 * @return viz popis
	*/
	public String GetString() {
		// vratime hodnotu polozky objektu pro zobrazeni
//		System.out.println("[" + m_sFieldName + "][" + m_iValue + "]");
		return GetRef().getParam(m_sFieldName).GetString();
	}
	
	/**
	 * Vrati hodnotu jako String - pro SQL
	 *
	 * @return viz popis
	*/
	public String GetSQLString() {
		return String.valueOf(GetRef().getID());
	}

	/**
	 * Vrati hodnotu jako String - naformatovanou
	 *
	 * @param sFormat formatovaci retezec
	 * @return viz popis
	*/
	public String GetFormatString(String sFormat) {
		// vratime hodnotu polozky objektu pro zobrazeni
		return GetRef().getParam(m_sFieldName).GetString();
	}

	/**
	 * Vrati hodnotu jako cele cislo
	 *
	 * @return cele cislo
	*/
	public int GetInt() {
		return GetRefID();
	}

}
