
package cz.luboss.medulla.types;

// knihovna
import cz.luboss.lubosslib.LException;

/**
	* Datovy typ retezec
	*
	* @author LKC
*/
public class MeFieldSTRING extends MeField{
	
	/** Parametr */
	protected String sValue = ""; 

	/** Konstruktor */
	protected MeFieldSTRING() {
	}

	/**
	 * Vytvari novy objekt i s hodnotami
	 *
	 * @param sName jmeno polozky
	 * @param sParam hodnota parametru
	 * @param bCanEdit signal, zda se muze editovat
	 * @return novy objekt
	*/
	public static MeFieldSTRING createInstance(String sName, String sParam, boolean bCanEdit) {
		MeFieldSTRING field = new MeFieldSTRING();
		field.m_sName = sName;
		field.m_bCanEdit = bCanEdit;
		field.sValue = sParam;
		return field;
	}

	/**
	 * Vrati ID typu
	 *
	 * @return ID typu
	*/
	public int GetType() {
		return MeField.STRING;
	}

	/**
	 * Nastavi hodnotu z retezce
	 *
	 * @param sParam retezec
	 * @return prubeh funkce
	*/
	public boolean SetString(String sParam) {
		sValue = sParam;
		return true;
	}

	/**
	 * Vrati hodnotu jako String
	 *
	 * @return viz popis
	*/
	public String GetString() {
		return sValue;
	}
	
	/**
	 * Vrati hodnotu jako String - pro SQL
	 *
	 * @return viz popis
	*/
	public String GetSQLString() {
    // vycistime od '
		return "'" + sValue.replaceAll("'",  "''") + "'";
	}

	/**
	 * Vrati hodnotu jako String - naformatovanou
	 *
	 * @param sFormat formatovaci retezec
	 * @return viz popis
	*/
	public String GetFormatString(String sFormat) {
		return sValue;
	}

	/**
	 * Vrati hodnotu jako cele cislo
	 *
	 * @return cele cislo
	*/
	public int GetInt() {
		throw new LException(this.getClass(), "Typ String neni mozne vratit jako Integer.");
	}

}
