
package cz.luboss.pensum.client;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

// definice
import cz.luboss.medulla.client.theme.*;
import cz.luboss.medulla.common.MeDefine;

// implmentace
import cz.luboss.pensum.client.panel.*;
import cz.luboss.pensum.common.PensumContext;

/**
	* Klient pro aplikaci Pensum
	*
	* @author LKC
*/
public class PeClient extends JPanel {

	/** Defaultni velikost */  
	private static final int PREFERRED_WIDTH = 800;
	/** Defaultni velikost */  
	private static final int PREFERRED_HEIGHT = 550;
	
	/** Frame aplikace */
	public JFrame m_fFrame = null;
	
	/** About box */
	private JDialog aboutBox = null;
	
	/** Menus celek*/
	private JMenuBar menuBar = null;
	/** Menus theme */
	private JMenu lafMenu = null;
	/** Menus povrchy */
	private JMenu themesMenu = null;
	/** Menus tlacitka v menu theme */
	private ButtonGroup lafMenuGroup = new ButtonGroup();
	/** Menus tlacitka v menu povrchy */
	private ButtonGroup themesMenuGroup = new ButtonGroup();

	/** Possible Look & Feels */
	private static final String mac      	= "com.sun.java.swing.plaf.mac.MacLookAndFeel";
	/** Possible Look & Feels */
	private static final String metal    	= "javax.swing.plaf.metal.MetalLookAndFeel";
	/** Possible Look & Feels */
	private static final String motif    	= "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
	/** Possible Look & Feels */
	private static final String windows  	= "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
	/** Possible Look & Feels */
	private static final String gtk  			= "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
	/** aktualni THEME */
	private static String currentLookAndFeel = metal;
	
	/** Vytvori a zobrazi aplikaci */
	private void createAndShowGUI() {
		//Make sure we have nice window decorations.
		JFrame.setDefaultLookAndFeelDecorated(true);
		JDialog.setDefaultLookAndFeelDecorated(true);
	
		// nastavime Context aplikace
		PensumContext.CreateInstance("penclient.cfg", MeDefine.DEF_DATAMACHINE_SQL, "lc", "");
//		PensumContext.CreateInstance("penclient.cfg", MeDefine.DEF_DATAMACHINE_RMI, "lc", "");
	
		//Create and set up the window.
		m_fFrame = new JFrame("PenClient 02");

		// testnem pridavani oken
		JPanel top = new JPanel();
		top.setLayout(new BorderLayout());
		m_fFrame.getContentPane().add(top, BorderLayout.NORTH);

		// vytvorime menu
		menuBar = createMenus();
		top.add(menuBar, BorderLayout.NORTH);

		// PropertySheet
		JTabbedPane m_TabbedPane = new JTabbedPane();
		m_TabbedPane.addTab(PensumContext.getRes("TAB_BEZICI_PRIKAZY"), PcJobsActualPanel.CreateInstance(m_fFrame));
		m_TabbedPane.addTab(PensumContext.getRes("TAB_VYROBKY"), PcProductsPanel.CreateInstance(m_fFrame));
		m_TabbedPane.addTab(PensumContext.getRes("TAB_DILCE"), PcPartsPanel.CreateInstance(m_fFrame));
		m_TabbedPane.addTab(PensumContext.getRes("TAB_MATERIALY"), PcMaterialsPanel.CreateInstance(m_fFrame));
		m_TabbedPane.addTab(PensumContext.getRes("TAB_PRACOVISTE"), PcPlacesPanel.CreateInstance(m_fFrame));
		m_TabbedPane.addTab(PensumContext.getRes("TAB_PRACOVNICI"), PcWorkersPanel.CreateInstance(m_fFrame));
    m_TabbedPane.addTab(PensumContext.getRes("TAB_RELACE"), PcSessionPanel.CreateInstance(m_fFrame));
		m_TabbedPane.setPreferredSize(new Dimension(PREFERRED_WIDTH,PREFERRED_HEIGHT));

		m_fFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		m_fFrame.getContentPane().add(m_TabbedPane);

		//Display the window.
		m_fFrame.pack();
		m_fFrame.setVisible(true);
	}
	
	/**
		* Vytvori menu
		* 
		* @return vytvorene menu
	*/
	public JMenuBar createMenus() {
		JMenuItem mi;
		// ***** create the menubar ****
		JMenuBar menuBar = new JMenuBar();
		menuBar.getAccessibleContext().setAccessibleName("MenuBar.accessible_description");

		 // ***** create File menu
		JMenu fileMenu = (JMenu) menuBar.add(new JMenu(PensumContext.getRes("MENU_SOUBOR")));
		fileMenu.setMnemonic('S');
		fileMenu.getAccessibleContext().setAccessibleDescription("FileMenu.accessible_description");
//		createMenuItem(fileMenu, PensumContext.GetRes("MENU_SOUBOR"), "FileMenu.about_mnemonic",
//					"FileMenu.about_accessible_description", new AboutAction(this));
//		 fileMenu.addSeparator();
		 createMenuItem(fileMenu, PensumContext.getRes("MENU_KONEC"), "FileMenu.exit_mnemonic",
				"FileMenu.exit_accessible_description", new ExitAction(this)
		 );

	 	// ***** create laf switcher menu
	 	lafMenu = (JMenu) menuBar.add(new JMenu(PensumContext.getRes("MENU_TYP_OKEN")));
		lafMenu.setMnemonic('T');
	 	lafMenu.getAccessibleContext().setAccessibleDescription("LafMenu.laf_accessible_description");

	 	mi = createLafMenuItem(lafMenu, PensumContext.getRes("MENU_TYP_OKEN_JAVA"), "LafMenu.java_mnemonic", "LafMenu.java_accessible_description", metal);
	 	mi.setSelected(true); // this is the default l&f
	 	createLafMenuItem(lafMenu, PensumContext.getRes("MENU_TYP_OKEN_MAC"), "LafMenu.mac_mnemonic", "LafMenu.mac_accessible_description", mac);
		createLafMenuItem(lafMenu, PensumContext.getRes("MENU_TYP_OKEN_MOTIF"), "LafMenu.motif_mnemonic", "LafMenu.motif_accessible_description", motif);
		createLafMenuItem(lafMenu, PensumContext.getRes("MENU_TYP_OKEN_WINDOWS"), "LafMenu.windows_mnemonic", "LafMenu.windows_accessible_description", windows);
		createLafMenuItem(lafMenu, PensumContext.getRes("MENU_TYP_OKEN_GTK"), "LafMenu.gtk_mnemonic", "LafMenu.gtk_accessible_description", gtk);

		// ***** create themes menu
		themesMenu = (JMenu) menuBar.add(new JMenu( PensumContext.getRes("MENU_THEME")));
		themesMenu.setMnemonic('X');
	 	themesMenu.getAccessibleContext().setAccessibleDescription("ThemesMenu.themes_accessible_description");

		// *** now back to adding color/font themes to the theme menu
		mi = createThemesMenuItem(themesMenu, "Standard", "ThemesMenu.default_mnemonic", "ThemesMenu.default_accessible_description", new DefaultMetalTheme());
		mi.setSelected(true); // This is the default theme
	 	createThemesMenuItem(themesMenu, "Aqua", "ThemesMenu.aqua_mnemonic", "ThemesMenu.aqua_accessible_description", new AquaTheme());
	 	createThemesMenuItem(themesMenu, "Charcoal", "ThemesMenu.charcoal_mnemonic", "ThemesMenu.charcoal_accessible_description", new CharcoalTheme());
	 	createThemesMenuItem(themesMenu, "Contrast", "ThemesMenu.contrast_mnemonic", "ThemesMenu.contrast_accessible_description", new ContrastTheme());
		createThemesMenuItem(themesMenu, "Contrast Metal", "ThemesMenu.misc_mnemonic", "ThemesMenu.misc_description", new ContrastMetalTheme());
		createThemesMenuItem(themesMenu, "BigContrast Metal", "ThemesMenu.misc_mnemonic", "ThemesMenu.misc_description", new BigContrastMetalTheme());
		createThemesMenuItem(themesMenu, "Demo Metal", "ThemesMenu.misc_mnemonic", "ThemesMenu.misc_description", new DemoMetalTheme());
	 	createThemesMenuItem(themesMenu, "Emerald", "ThemesMenu.emerald_mnemonic", "ThemesMenu.emerald_accessible_description", new EmeraldTheme());
		createThemesMenuItem(themesMenu, "Green Metal", "ThemesMenu.misc_mnemonic", "ThemesMenu.misc_description", new GreenMetalTheme());
		createThemesMenuItem(themesMenu, "Khaki Metal", "ThemesMenu.misc_mnemonic", "ThemesMenu.misc_description", new KhakiMetalTheme());
		createThemesMenuItem(themesMenu, "Ruby", "ThemesMenu.ruby_mnemonic", "ThemesMenu.ruby_accessible_description", new RubyTheme());
 		return menuBar;
	 }

	public static void main(String[] args) {
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				PeClient app = new PeClient(); 
				app.createAndShowGUI();
			}
		});
	}

	/**
	 * Vytvori menu pro polozku
	 * 
	 * menu, String label, String mnemonic,String accessibleDescription, Action action
	 */
	public JMenuItem createMenuItem(JMenu menu, String label, String mnemonic,String accessibleDescription, Action action) {
		JMenuItem mi = (JMenuItem) menu.add(new JMenuItem(label));
		mi.setMnemonic('X');
		mi.getAccessibleContext().setAccessibleDescription(accessibleDescription);
		mi.addActionListener(action);
		if(action == null) {
			mi.setEnabled(false);
		}
		return mi;
	}
	
	/**
	 * Vytvori JRadioButtonMenuItem pro menu Themes
	 * menu, String label, String mnemonic,
				   String accessibleDescription, DefaultMetalTheme theme
	 */
	public JMenuItem createThemesMenuItem(JMenu menu, String label, String mnemonic,
				   String accessibleDescription, DefaultMetalTheme theme) {
		JRadioButtonMenuItem mi = (JRadioButtonMenuItem) menu.add(new JRadioButtonMenuItem(label));
		themesMenuGroup.add(mi);
		mi.setMnemonic('X');
		mi.getAccessibleContext().setAccessibleDescription(accessibleDescription);
		mi.addActionListener(new ChangeThemeAction(this, theme));
		return mi;
	}

	/**
	 * Vytvori JRadioButtonMenuItem pro Look and Feel menu
	 * JMenu menu, String label, String mnemonic, String accessibleDescription, String laf
	 */
	public JMenuItem createLafMenuItem(JMenu menu, String label, String mnemonic, 
		String accessibleDescription, String laf) {
		JMenuItem mi = (JRadioButtonMenuItem) menu.add(new JRadioButtonMenuItem(label));
		lafMenuGroup.add(mi);
		mi.setMnemonic('X');
		mi.getAccessibleContext().setAccessibleDescription(accessibleDescription);
		mi.addActionListener(new ChangeLookAndFeelAction(this, laf));
	
		mi.setEnabled(isAvailableLookAndFeel(laf));
	
		return mi;
	}
	
	/** Zmena typu oken */
	class ChangeLookAndFeelAction extends AbstractAction {
		PeClient swingset;
		String laf;
			protected ChangeLookAndFeelAction(PeClient swingset, String laf) {
				super("ChangeTheme");
			this.swingset = swingset;
			this.laf = laf;
			}
	
			public void actionPerformed(ActionEvent e) {
			swingset.setLookAndFeel(laf);
		}
	}

	/** 
	 * Zmena povrchu oken 
	 *
	 * @param laf jmeno povrchu
	*/
	public void setLookAndFeel(String laf) {
		if(currentLookAndFeel != laf) {
			currentLookAndFeel = laf;
			themesMenu.setEnabled(laf == metal);
			updateLookAndFeel();
		}
	}

	/** Znovu zobrazi aplikaci po zmene povrchu ... */
	public void updateLookAndFeel() {
		try {
			UIManager.setLookAndFeel(currentLookAndFeel);
//			for (Iterator itr = swingSets.iterator(); itr.hasNext(); ) {
//				SwingSet2 ss = (SwingSet2)itr.next();
//				SwingUtilities.updateComponentTreeUI(ss);
//			}
			// update LAF for the toplevel frame, too
			SwingUtilities.updateComponentTreeUI(m_fFrame);
//			SwingUtilities.updateComponentTreeUI(popupMenu);
		} catch (Exception ex) {
			System.out.println("Failed loading L&F: " + currentLookAndFeel);
			System.out.println(ex);
		}

		// lazily update update the UI's for the remaining demos
/*		for (int i = 0; i < demosVector.size(); i++) {
			DemoModule demo = (DemoModule) demosVector.elementAt(i);
			if(currentDemo != demo) {
			// do the following on the gui thread
			SwingUtilities.invokeLater(new SwingSetRunnable(this, demo) {
				public void run() {
				SwingUtilities.updateComponentTreeUI(((DemoModule)obj).getDemoPanel());
				}
			});
			}
		}
*/	}

	/**
	 * A utility function that layers on top of the LookAndFeel's
	 * isSupportedLookAndFeel() method. Returns true if the LookAndFeel
	 * is supported. Returns false if the LookAndFeel is not supported
	 * and/or if there is any kind of error checking if the LookAndFeel
	 * is supported.
	 *
	 * The L&F menu will use this method to detemine whether the various
	 * L&F options should be active or inactive.
	 *
	 */
	 protected boolean isAvailableLookAndFeel(String laf) {
		 try {
			 Class lnfClass = Class.forName(laf);
			 LookAndFeel newLAF = (LookAndFeel)(lnfClass.newInstance());
			 return newLAF.isSupportedLookAndFeel();
		 } catch(Exception e) { // If ANYTHING weird happens, return false
			 return false;
		 }
	 }

	// vytvori iconku
	public ImageIcon createImageIcon(String filename) {
		String path = "/resources/images/" + filename;
		return new ImageIcon(getClass().getResource(path));
	}

	/** About dialog */
	class AboutPanel extends JPanel {
		ImageIcon aboutimage = null;
		PeClient swingset = null;
		
		public AboutPanel(PeClient swingset) {
			this.swingset = swingset;
			 aboutimage = swingset.createImageIcon("about.jpg");
			 setOpaque(false);
		}		
		public void paint(Graphics g) {aboutimage.paintIcon(this, g, 0, 0);
			super.paint(g);
		}
		
		public Dimension getPreferredSize() {
			return new Dimension(aboutimage.getIconWidth(), aboutimage.getIconHeight());
		}
	}

	// *******************************************************
	// ********************   Actions  ***********************
	// *******************************************************
	
	class AboutAction extends AbstractAction {
		PeClient swingset;
		protected AboutAction(PeClient swingset) {
			super("AboutAction");
			this.swingset = swingset;
		}
		
		public void actionPerformed(ActionEvent e) {
			if(aboutBox == null) {
				// JPanel panel = new JPanel(new BorderLayout());
				JPanel panel = new AboutPanel(swingset);
				panel.setLayout(new BorderLayout());
				
				aboutBox = new JDialog(swingset.m_fFrame, "AboutBox.title", false);
				aboutBox.getContentPane().add(panel, BorderLayout.CENTER);
				
				// JButton button = new JButton(getString("AboutBox.ok_button_text"));
				JPanel buttonpanel = new JPanel();
				buttonpanel.setOpaque(false);
				JButton button = (JButton) buttonpanel.add(new JButton(PensumContext.getRes("BUTTON_OK")));
				panel.add(buttonpanel, BorderLayout.SOUTH);
				
				button.addActionListener(new OkAction(aboutBox));
			}
			aboutBox.pack();
			Point p = swingset.getLocationOnScreen();
			aboutBox.setLocation(p.x + 10, p.y +10);
			aboutBox.setVisible(true);
		}
	}
	
	class OkAction extends AbstractAction {
		JDialog aboutBox;
		
		protected OkAction(JDialog aboutBox) {
			super("OkAction");
			this.aboutBox = aboutBox;
		}
		
		public void actionPerformed(ActionEvent e) {
			aboutBox.setVisible(false);
		}
	}

	class ExitAction extends AbstractAction {
		PeClient swingset;
		
		protected ExitAction(PeClient swingset) {
			super("ExitAction");
			this.swingset = swingset;
		}
	
		public void actionPerformed(ActionEvent e) {
			System.exit(0);
		}
	}

	class ChangeThemeAction extends AbstractAction {
		PeClient swingset;
		DefaultMetalTheme theme;
		protected ChangeThemeAction(PeClient swingset, DefaultMetalTheme theme) {
			super("ChangeTheme");
			this.swingset = swingset;
			this.theme = theme;
		}
	
		public void actionPerformed(ActionEvent e) {
			MetalLookAndFeel.setCurrentTheme(theme);
			swingset.updateLookAndFeel();
		}
	}

}