package cz.luboss.pensum.client.panel;

import java.awt.*;

import javax.swing.JFrame;
import javax.swing.JSplitPane;

// definice
import cz.luboss.medulla.common.MePodminka;

// implementace
import cz.luboss.pensum.client.view.*;
import cz.luboss.pensum.gener.*;

/**
 * Okno s vypisem aktivnich vyrobnich prikazu
 * 
 * @author LKC 
*/
public class PcJobsActualPanel extends JSplitPane {

	/** 
	 * Konstruktor s parametry 
	 * 
	 * @param newOrientation orientace oken ve splitu
	 * @param newLeftComponent leve okno splitu
	 * @param newRightComponent prave okno splitu
	*/ 
	public PcJobsActualPanel(int newOrientation, Component newLeftComponent, Component newRightComponent) {
		super(newOrientation, newLeftComponent, newRightComponent);		
	}

  /** 
   * Vytvorime objekt
   * 
   * @param frame aktualni frame
   * @return novy objekt  
  */
  public static PcJobsActualPanel CreateInstance(JFrame frame) {
		// vytvorime data
		MePodminka podMinka = MePodminka.createInstance("pejob_id", MePodminka.NEROVNO, "null");
		PeJobArray arrJob = PeJobArray.createInstance();
		PeTaskArray arrTask = PeTaskArray.createInstance();
		PeRunProductArray arrVyrobek = PeRunProductArray.createInstance();
		PeRunPartArray arrDilec = PeRunPartArray.createInstance();
		arrJob.loadArray(podMinka);
  	
		// vytvorime tabulky
		PeJobGrid panelJob = PeJobGrid.CreateGrid(frame, arrJob);
		PeTaskGrid panelTask = PeTaskGrid.CreateGrid(frame, arrTask);
		PeRunProductGrid panelVyrobek = PeRunProductGrid.CreateGrid(frame, arrVyrobek);
		PeRunPartGrid panelDilec = PeRunPartGrid.CreateGrid(frame, arrDilec);

		panelJob.SetPodminka(podMinka); 
		panelTask.AddTableChild(panelVyrobek, MePodminka.createInstance("petask_id", 0));
		panelJob.AddTableChild(panelVyrobek, MePodminka.createInstance("pejob_id", 0));
		panelVyrobek.AddTableChild(panelDilec, MePodminka.createInstance("perunproduct_id", 0));

		// splitove okno
		JSplitPane m_SplitPane02 = new JSplitPane(JSplitPane.VERTICAL_SPLIT, 
			PcHeaderPanel.CreateInstance(panelVyrobek, PcHeaderPanel.DEF_HEAD_WITH_STATUS_BUTTONS), 
			PcHeaderPanel.CreateInstance(panelDilec, PcHeaderPanel.DEF_HEAD_WITH_STATUS_BUTTONS));
		m_SplitPane02.setContinuousLayout(true);
		m_SplitPane02.setOneTouchExpandable(true);
		m_SplitPane02.setDividerLocation(150);

		JSplitPane m_SplitPane01 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, 
			PcHeaderPanel.CreateInstance(panelTask, PcHeaderPanel.DEF_HEAD_WITH_GRID_BUTTONS), m_SplitPane02);
		m_SplitPane01.setContinuousLayout(true);
		m_SplitPane01.setOneTouchExpandable(true);
		m_SplitPane01.setDividerLocation(350);
	
		// popis tlacitek
		int[] buttony = new int[] {PcHeaderPanel.DEF_HEAD_WITH_GRID_BUTTONS, PcHeaderPanel.DEF_HEAD_WITH_FILTER, PcHeaderPanel.DEF_HEAD_WITH_ADD_PRODUCT_BUTTONS};
		PcJobsActualPanel pane = new PcJobsActualPanel(JSplitPane.VERTICAL_SPLIT, 
			PcHeaderPanel.CreateInstance(panelJob, buttony), m_SplitPane01);
		pane.setContinuousLayout(true);
		pane.setOneTouchExpandable(true);
		pane.setDividerLocation(150);
	
		return pane;
  }
}
