package cz.luboss.pensum.client.panel;

import java.awt.Component;
import javax.swing.*;

// definice
import cz.luboss.medulla.common.MePodminka;

// implementace
import cz.luboss.pensum.client.view.*;
import cz.luboss.pensum.gener.*;

/**
 * Okno s vypisem dilcu
 * 
 * @author LKC 
*/
public class PcPartsPanel extends JSplitPane {

	/** 
	 * Konstruktor s parametry 
	 * 
	 * @param newOrientation orientace oken ve splitu
	 * @param newLeftComponent leve okno splitu
	 * @param newRightComponent prave okno splitu
	*/ 
  public PcPartsPanel(int newOrientation, Component newLeftComponent, Component newRightComponent) {
	  super(newOrientation, newLeftComponent, newRightComponent);		
  }

  /** 
   * Vytvorime objekt
   * 
   * @param frame aktualni frame
   * @return novy objekt  
  */
	public static PcPartsPanel CreateInstance(JFrame frame) {
	  // vytvorime data
	  PePartArray arrDilec = PePartArray.createInstance();
	  arrDilec.loadArray(null);
	  PeOperationArray arrOperace = PeOperationArray.createInstance();
	  PePartMaterialArray arrPartMaterial = PePartMaterialArray.createInstance();

	  // vytvorime tabulky
	  PePartGrid 					panelDilec = PePartGrid.CreateGrid(frame, arrDilec);
	  PeOperationGrid 		panelOper = PeOperationGrid.CreateGrid(frame, arrOperace);
	  PePartMaterialGrid 	panelMater = PePartMaterialGrid.CreateGrid(frame, arrPartMaterial);

	  panelDilec.AddTableChild(panelOper, MePodminka.createInstance("pepart_id", 0));
	  panelDilec.AddTableChild(panelMater, MePodminka.createInstance("pepart_id", 0));
	
	  // splitove okno
	  JSplitPane m_SplitPane02 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, 
		  PcHeaderPanel.CreateInstance(panelOper, PcHeaderPanel.DEF_HEAD_WITH_GRID_BUTTONS), 
		  PcHeaderPanel.CreateInstance(panelMater, PcHeaderPanel.DEF_HEAD_WITH_GRID_BUTTONS));
	  m_SplitPane02.setContinuousLayout(true);
	  m_SplitPane02.setOneTouchExpandable(true);
	  m_SplitPane02.setDividerLocation(400);

	  PcPartsPanel pane = new PcPartsPanel(JSplitPane.VERTICAL_SPLIT, 
		  PcHeaderPanel.CreateInstance(panelDilec, PcHeaderPanel.DEF_HEAD_WITH_GRID_BUTTONS), m_SplitPane02);
		pane.setContinuousLayout(true);
		pane.setOneTouchExpandable(true);
		pane.setDividerLocation(300);

	  return pane;
	}

}
