package cz.luboss.pensum.client.panel;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

// definice
import cz.luboss.medulla.common.MePodminka;

// implementace
import cz.luboss.pensum.client.view.*;
import cz.luboss.pensum.gener.*;

/**
 * Okno s vypisem vyrobku
 * 
 * @author LKC 
*/
public class PcProductsPanel extends JSplitPane {

	/** 
	 * Konstruktor s parametry 
	 * 
	 * @param newOrientation orientace oken ve splitu
	 * @param newLeftComponent leve okno splitu
	 * @param newRightComponent prave okno splitu
	*/ 
	public PcProductsPanel(int newOrientation, Component newLeftComponent, Component newRightComponent) {
		super(newOrientation, newLeftComponent, newRightComponent);		
	}

	/** 
	 * Vytvorime objekt
	 * 
	 * @param frame aktualni frame
	 * @return novy objekt  
	*/
  public static PcProductsPanel CreateInstance(JFrame frame) {
		// vytvorime data
		MePodminka podMinka = MePodminka.createInstance("peproduct_id", MePodminka.NEROVNO, "null");
		PeProductArray arrVyrobek = PeProductArray.createInstance();
		PeProductPartArray arrDilec = PeProductPartArray.createInstance();
		PeOperationArray arrOperace = PeOperationArray.createInstance();
		PePartMaterialArray arrPartMaterial = PePartMaterialArray.createInstance();
		arrVyrobek.loadArray(podMinka);

 		// vytvorime tabulky
		PeProductGrid 			panelVyrobek = PeProductGrid.CreateGrid(frame, arrVyrobek);
		PeProductPartGrid 	panelDilec = PeProductPartGrid.CreateGrid(frame, arrDilec);
		PeOperationGrid 		panelOper = PeOperationGrid.CreateGrid(frame, arrOperace);
		PePartMaterialGrid 	panelMater = PePartMaterialGrid.CreateGrid(frame, arrPartMaterial);

		panelVyrobek.SetPodminka(podMinka); 
		panelVyrobek.AddTableChild(panelDilec, MePodminka.createInstance("peproduct_id", 0));
		panelDilec.AddTableChild(panelOper, MePodminka.createInstance("pepart_id", 0));
		panelDilec.AddTableChild(panelMater, MePodminka.createInstance("pepart_id", 0));
	
		// splitove okno
		JSplitPane m_SplitPane02 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, 
			PcHeaderPanel.CreateInstance(panelOper, PcHeaderPanel.DEF_HEAD_ONLY_LABEL), 
			PcHeaderPanel.CreateInstance(panelMater, PcHeaderPanel.DEF_HEAD_ONLY_LABEL));
		m_SplitPane02.setContinuousLayout(true);
		m_SplitPane02.setOneTouchExpandable(true);
		m_SplitPane02.setDividerLocation(400);

		JSplitPane m_SplitPane01 = new JSplitPane(JSplitPane.VERTICAL_SPLIT, 
			PcHeaderPanel.CreateInstance(panelDilec, PcHeaderPanel.DEF_HEAD_WITH_GRID_BUTTONS), m_SplitPane02);
		m_SplitPane01.setContinuousLayout(true);
		m_SplitPane01.setOneTouchExpandable(true);
		m_SplitPane01.setDividerLocation(150);

		int[] buttony = new int[] {PcHeaderPanel.DEF_HEAD_WITH_GRID_BUTTONS, PcHeaderPanel.DEF_HEAD_WITH_FILTER};
		PcProductsPanel pane = new PcProductsPanel(JSplitPane.VERTICAL_SPLIT, 
			PcHeaderPanel.CreateInstance(panelVyrobek, buttony), m_SplitPane01);
		pane.setContinuousLayout(true);
		pane.setOneTouchExpandable(true);
		pane.setDividerLocation(150);
	
		return pane;
  }
}
