package cz.luboss.pensum.client.panel;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

// definice
import cz.luboss.medulla.common.MePodminka;

// implementace
import cz.luboss.pensum.client.view.*;
import cz.luboss.pensum.gener.*;

/**
 * Okno s vypisem pracovniku
 * 
 * @author LKC 
*/
public class PcWorkersPanel extends JSplitPane {

	/** 
	 * Konstruktor s parametry 
	 * 
	 * @param newOrientation orientace oken ve splitu
	 * @param newLeftComponent leve okno splitu
	 * @param newRightComponent prave okno splitu
	*/ 
	public PcWorkersPanel(int newOrientation, Component newLeftComponent, Component newRightComponent) {
		super(newOrientation, newLeftComponent, newRightComponent);		
	}

	/** 
	 * Vytvorime objekt
	 * 
	 * @param frame aktualni frame
	 * @return novy objekt  
	*/
  public static PcWorkersPanel CreateInstance(JFrame frame) {
		// vytvorime data
		MePodminka podMinka = MePodminka.createInstance("peworker_id", MePodminka.NEROVNO, "null");
		PeWorkerArray arrWorker = PeWorkerArray.createInstance();
		PeScrapArray arrScrap = PeScrapArray.createInstance();
		arrWorker.loadArray(podMinka);
  	
		// vytvorime tabulky
		PeWorkerGrid panel10 = PeWorkerGrid.CreateGrid(frame, arrWorker);
		PeScrapGrid	panel11 = PeScrapGrid.CreateGrid(frame, arrScrap);

		panel10.SetPodminka(podMinka); 
		panel10.AddTableChild(panel11, MePodminka.createInstance("peworker_id", 0));
	
		// splitove okno
		int[] buttony = new int[] {PcHeaderPanel.DEF_HEAD_WITH_GRID_BUTTONS, PcHeaderPanel.DEF_HEAD_WITH_FILTER};
		PcWorkersPanel pane = new PcWorkersPanel(JSplitPane.VERTICAL_SPLIT, 
			PcHeaderPanel.CreateInstance(panel10, buttony), 
			PcHeaderPanel.CreateInstance(panel11, PcHeaderPanel.DEF_HEAD_WITH_GRID_BUTTONS));
		pane.setContinuousLayout(true);
		pane.setOneTouchExpandable(true);
		pane.setDividerLocation(150);
	
		return pane;
  }
}
