package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// defnice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.types.MeFieldREF;

// implementace
import cz.luboss.pensum.gener.PeOperation;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McGrid;

/**
 * Grid pro zobrazeni PeOperation
 * 
 * @author LKC
*/
public class PeOperationGrid extends McGrid {

	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeOperationGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeOperationGrid grid = new PeOperationGrid();
		grid.setName("Operace");
		grid.m_arrData = arrData;

		// nacteme defaultni sloupce
		PeOperation oper = (PeOperation) PeOperation.createInstance();
		grid.m_arrColumn = oper.getColumns();

		grid.Inicialize(frame);
		return grid; 
 	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
		PeOperation oper = (PeOperation) PeOperation.createInstance();
    MedullaContext.Register(oper);
		((MeFieldREF) oper.getParam(m_iPodminka.GetName())).SetRefID(Integer.parseInt(m_iPodminka.GetValue()));
		McDialog dlg = McDialog.CreateDlg(null, oper);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}

	/**
	 * Smaze jednu polozku
	 *
	 * @param iItem smazana polozka
	 * @return prubeh funkce
	*/ 
	public boolean DeleteItem(MeItem iItem) {
		iItem.delete();
		return true;
	}

}
