package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.types.MeFieldREF;

// implementace
import cz.luboss.pensum.gener.PePartMaterial;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PePartMaterial
 * 
 * @author LKC
*/
public class PePartMaterialGrid extends McParentGrid {

	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PePartMaterialGrid CreateGrid(JFrame frame, MeArray arrData) {
		PePartMaterialGrid grid = new PePartMaterialGrid();
	 	grid.m_arrData = arrData;
	 	grid.setName("Materily");
	  
	 	// nacteme defaultni sloupce
		PePartMaterial partMater = (PePartMaterial) PePartMaterial.createInstance();
	 	grid.m_arrColumn = partMater.getColumns();

  	grid.Inicialize(frame);
  	return grid; 
	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
    PePartMaterial dilec_mat = (PePartMaterial) PePartMaterial.createInstance();
    MedullaContext.Register(dilec_mat);
		// naplnime rodicovsky 
		((MeFieldREF)dilec_mat.getParam(m_iPodminka.GetName())).SetRefID(Integer.parseInt(m_iPodminka.GetValue()));
		McDialog dlg = McDialog.CreateDlg(null, dilec_mat);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		return 0;
	}

}
