package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.common.MePodminka;
import cz.luboss.medulla.data.MeArray;

// implementace
import cz.luboss.pensum.gener.PeProduct;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.print.McPrinter;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PeProduct
 * 
 * @author LKC
*/
public class PeProductGrid extends McParentGrid {

	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeProductGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeProductGrid grid = new PeProductGrid();
		grid.m_arrData = arrData;
		grid.setName("Vrobky");
		  
		// nacteme defaultni sloupce
		PeProduct product = (PeProduct) PeProduct.createInstance();
		grid.m_arrColumn = product.getColumns();

		grid.Inicialize(frame);
		return grid; 
	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
		PeProduct vyrobek = (PeProduct) PeProduct.createInstance();
    MedullaContext.Register(vyrobek);
		McDialog dlg = McDialog.CreateDlg(null, vyrobek);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}

	/** 
	 * Vytiskneme tabulku 
	 *
	 * @param bAllRows pokud se ma tisknout cela tabulka
	 * @param nRow jeden radek
	 * @return prubeh metody 
	*/
  public boolean PrintData(boolean bAllRows, int nRow) {
		String sFileName = "seznam_vyrobek.xml";
		MePodminka pod = m_iPodminka;
  	// pokud se maji tisknout vsechny radky
  	if (bAllRows) {
			sFileName = "vyrobek.xml";
			pod = MePodminka.createInstance(m_arrData.getItem(nRow).getNameID(), m_arrData.getItem(nRow).getID());
  	}
		return McPrinter.PrintData(sFileName, pod);	
	}

}
