package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.types.MeFieldREF;

// implementace
import cz.luboss.pensum.gener.PeProductPart;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PeProductPart
 * 
 * @author LKC
*/
public class PeProductPartGrid extends McParentGrid {

	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeProductPartGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeProductPartGrid grid = new PeProductPartGrid();
	  	grid.m_arrData = arrData;
	  	grid.setName("Dlce");
	  	
		// nacteme defaultni sloupce
		PeProductPart productPart = (PeProductPart) PeProductPart.createInstance();
		grid.m_arrColumn = productPart.getColumns();

		grid.Inicialize(frame);
		return grid; 
  	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
		PeProductPart product_dilec = (PeProductPart) PeProductPart.createInstance();
    MedullaContext.Register(product_dilec);
		((MeFieldREF)product_dilec.getParam("peproduct_id")).SetRefID(Integer.parseInt(this.m_iPodminka.GetValue()));
		McDialog dlg = McDialog.CreateDlg(null, product_dilec);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}

}
