package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.types.MeFieldREF;

// implementace
import cz.luboss.pensum.gener.PeRunOperation;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PeRunOperation
 * 
 * @author LKC
*/
public class PeRunOperationGrid extends McParentGrid {

	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeRunOperationGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeRunOperationGrid grid = new PeRunOperationGrid();
	  	grid.m_arrData = arrData;
	  	grid.setName("Operace");

	 	// nacteme defaultni sloupce
		PeRunOperation runOper = (PeRunOperation) PeRunOperation.createInstance();
	  	grid.m_arrColumn = runOper.getColumns();

		grid.Inicialize(frame);
		return grid; 
	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
		PeRunOperation dilec = PeRunOperation.createInstance();
    MedullaContext.Register(dilec);
		((MeFieldREF)dilec.getParam(m_iPodminka.GetName())).SetRefID(Integer.parseInt(m_iPodminka.GetValue()));
		McDialog dlg = McDialog.CreateDlg(null, dilec);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}

}
