package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.types.MeFieldREF;

// implementace
import cz.luboss.pensum.gener.PeRunPart;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PeRunPart
 * 
 * @author LKC
*/
public class PeRunPartGrid extends McParentGrid {

	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeRunPartGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeRunPartGrid grid = new PeRunPartGrid();
	  	grid.m_arrData = arrData;
	  	grid.setName("Dlce");

		// nacteme defaultni sloupce
		PeRunPart runPart = (PeRunPart) PeRunPart.createInstance();
		grid.m_arrColumn = runPart.getColumns();

		grid.Inicialize(frame);
		return grid; 
  }
  
  /**
   * Prida jednu polozku
   *  
   * @return radek nove polozky 
  */ 
	public int AddItem() {
    MedullaContext.StartTransaction();
    PeRunPart dilec = (PeRunPart) PeRunPart.createInstance();
    MedullaContext.Register(dilec);
		// naplnime rodicovsky 
		((MeFieldREF)dilec.getParam(m_iPodminka.GetName())).SetRefID(Integer.parseInt(m_iPodminka.GetValue()));
		McDialog dlg = McDialog.CreateDlg(null, dilec);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}

	/**
	 * Smaze jednu polozku
	 *
	 * @param iItem smazana polozka
	 * @return prubeh funkce
	*/ 
	public boolean DeleteItem(MeItem iItem) {
		iItem.delete();
		return true;
	}

}
