package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.types.MeFieldREF;

// implementace
import cz.luboss.pensum.gener.PeRunProduct;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PeRunProduct
 * 
 * @author LKC
*/
public class PeRunProductGrid extends McParentGrid {
	
	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeRunProductGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeRunProductGrid grid = new PeRunProductGrid();
	  	grid.m_arrData = arrData;
	  	grid.setName("Vrobky");

	  	// nacteme defaultni sloupce
		PeRunProduct runProduct = (PeRunProduct) PeRunProduct.createInstance();
		grid.m_arrColumn = runProduct.getColumns();
	
		grid.Inicialize(frame);
		return grid; 
	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
		PeRunProduct vyrobek = PeRunProduct.createInstance();
    MedullaContext.Register(vyrobek);
		// naplnime rodicovsky 
		((MeFieldREF) vyrobek.getParam(m_iPodminka.GetName())).SetRefID(Integer.parseInt(m_iPodminka.GetValue()));
		McDialog dlg = McDialog.CreateDlg(null, vyrobek);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}

}
