
package cz.luboss.pensum.common;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.factory.*;
import cz.luboss.medulla.data.*;

// implmentace
import cz.luboss.pensum.common.PeConfig;
import cz.luboss.pensum.factory.PeDataMachine;
import cz.luboss.pensum.factory.PeDataMachineSQL;
import cz.luboss.pensum.factory.PeDataMachineRMI;
import cz.luboss.pensum.gener.PeParamSQL_MySQL;

/**
	* Pracovn kontext pro Pensum - staticka trida zastresujici PeContext
	*
	* @author LKC
*/
public class PensumContext extends MedullaContext {

	/** 
	 * Nacte context ze zadanych parametru 
	 * 
	 * @param sFileConf konfiguracni soubor
	 * @param nDataType typ datoveho zdroje (SQL, RMI, ....)
	 * @return viz popis
	*/
	public static boolean CreateInstance(String sFileConf, int nDataType) {
		// nejdriv vytvorime kontext
		MedullaContext.m_PenContext = MeContext.CreateInstance();

		// vytvorime konfiguraci
		MeConfig conf = PeConfig.createInstance(sFileConf);

    // nastavime logovani Log4J
    MedullaContext.setConfLog4J(conf.getParam("LOG4J_FILE"));
    // a rovnou zalogujeme
    MedullaContext.logInfo(PensumContext.class, "Spusten modul Pensum.");
   
		// vytvorime Machinu pro zpracovani dat
		PeDataMachine dataMachine = null;
		if (nDataType == MeDefine.DEF_DATAMACHINE_SQL) {
      // pouzijemem databazi MySQL
      MeParamSQL param = PeParamSQL_MySQL.createInstance();
			dataMachine = PeDataMachineSQL.CreateInstance(param);
      conf.setParam(MeConfig.DRIVERNAME, param.getDriver());
      conf.setParam(MeConfig.SEQUENCE_TABLE, param.getSequence());
			MeConnectSQL dbConnect = MeConnectSQL.CreateInstance(conf.getParam(MeConfig.DRIVERNAME),
				conf.getParam(MeConfig.CONNECTSTRING), conf.getParam(MeConfig.USERDB), conf.getParam(MeConfig.PASSDB));
			dataMachine.SetConnect(dbConnect);
      MedullaContext.logInfo(PensumContext.class, "Nastavena DataMachine SQL.");
		}
		else if (nDataType == MeDefine.DEF_DATAMACHINE_RMI) {
			dataMachine = PeDataMachineRMI.CreateInstance();
			MeConnectRMI dbConnect = MeConnectRMI.CreateInstance(conf.getParam(PeConfig.REMOTESERVER),
				conf.getParam(PeConfig.REMOTECLASS));
			dataMachine.SetConnect(dbConnect);
      MedullaContext.logInfo(PensumContext.class, "Nastavena DataMachine RMI.");
		}

		// nastavime logger a naplnime objekty
		return MedullaContext.m_PenContext.SetConf(conf) && MedullaContext.m_PenContext.SetMachine(dataMachine);
	}

	/**
	 * Vytvori novy objet i s uzivatelskou session
	 *
	 * @param sFileConf konfiguracni soubor
	 * @param nDataType typ datoveho zdroje (SQL, RMI, ....)
	 * @param sLogin jmeno uzivatele
	 * @param sPasswd heslo
	 * @return viz popis
	*/
	public static boolean CreateInstance(String sFileConf, int nDataType, String sLogin, String sPasswd) {
		return PensumContext.CreateInstance(sFileConf, nDataType)
			&& MedullaContext.m_PenContext.SetSession(PensumContext.GetRunMachine().LoadSession(sLogin, sPasswd));
	}

  /**
	 * Vrati masinu pro praci s daty 
	 * 
	 * @return viz popis
	*/
	public static PeDataMachine GetRunMachine() {
		return (PeDataMachine) MedullaContext.GetMachine();
	}

////////////////////////////////////////////////////////////////////////////////////////////////
// Ostatni metody jsou prepsane z MedullaContext, jelikoz JAVA neumi dedit staticke metody :-(((
////////////////////////////////////////////////////////////////////////////////////////////////
  
	/**
	 * Vrati hodnotu konfigurace
	 *
   *@param sParam parametr configurace
	 *@return    viz popis
	 */
	public static String getConfParam(String sParam) {
		return MedullaContext.getConfParam(sParam);
	}

	/**
	 * Vrati uzivatelskou session
	 *
	 * @return    viz popis
	 */
	public static MeSession GetSession() {
		return MedullaContext.GetSession();
	}

	/**
	 * Vrati ID uzivatelske session
	 *
	 * @return    viz popis
	 */
	public static int GetSessionID() {
		return MedullaContext.GetSession().getID();
	}

	/**
	 * Vrati text popisu podle jazyka uzivatele
	 *
	 * @param  sName  jmeno textu
	 * @return        viz popis
	 */
	public static String getRes(String sName) {
		return MedullaContext.getRes(sName);
	}

  /**
	 * Zacne novou transakci
	 *
	 * @return prubeh funkce
	*/
	public static boolean StartTransaction() {
    return MedullaContext.StartTransaction();
  }
  
	/**
	 * Vrati vsechny prvky zmenene v teto transakci do puvodniho stavu
	 *
	 * @return vrati prubeh fukce
	*/
	public static boolean RollBack() {
    return MedullaContext.RollBack();
  }

	/**
	 * Potvrdi vsechny provedene zmeny
	 *
	 * @return vrati prubeh fukce
	*/
	public static boolean Commit() {
    return MedullaContext.Commit();
  }

	/**
	 * Zaregistruje objekt do transakce
	 *
	 * @return vrati prubeh fukce
	*/
	public static boolean Register(MeItem item) {
    return MedullaContext.Register(item);
  }

	/**
	 * Odregistruje objekt z transakce
	 *
	 * @return vrati prubeh fukce
	*/
	public static boolean UnRegister(MeItem item) {
    return MedullaContext.UnRegister(item);
  }
  
  /**
	 * Nahrajeme objekt
	 *
   * @param item objekt
   * @param nID ID objekt
	 * @return viz popis
	*/
  public static boolean LoadData(MeItem item, int nID) {
    return MedullaContext.LoadData(item, nID);
  }

  /**
	 * Nahrajeme pole objektu
	 *
   * @param array pole
   * @param iPodminka podlminka vyberu
	 * @return viz popis
	*/
  public static boolean LoadArray(MeArray array, MePodminka iPodminka) {
    return MedullaContext.LoadArray(array, iPodminka);
  }

  /**
	 * Smaze objekt
	 *
   * @param item objekt
   * @param nID ID objekt
	 * @return viz popis
	*/
  public static boolean DeleteData(MeItem item, int nID) {
		return MedullaContext.DeleteData(item, nID);
	}

  /**
	 * Zaloguje zpravu s objektem na uroven DEBUG
	 *
   * @param trida trida, pro jiz se loguje
   * @param sText ID objekt
	*/
  public static void logDebug(Class trida, String sText) {
    MedullaContext.logDebug(trida, sText);
	}

  /**
	 * Zaloguje zpravu s objektem na uroven INFO
	 *
   * @param trida trida, pro jiz se loguje
   * @param sText ID objekt
	*/
  public static void logInfo(Class trida, String sText) {
    MedullaContext.logInfo(trida, sText);
	}

  /**
	 * Zaloguje zpravu s objektem na uroven WARN
	 *
   * @param trida trida, pro jiz nehoz se loguje
   * @param sText ID objekt
	*/
  public static void logWarn(Class trida, String sText) {
    MedullaContext.logWarn(trida, sText);
	}

  /**
	 * Zaloguje zpravu s objektem na uroven ERROR
	 *
   * @param trida trida, pro jiz nehoz se loguje
   * @param sText ID objekt
	*/
  public static void logError(Class trida, String sText) {
    MedullaContext.logError(trida, sText);
	}

}
