
package cz.luboss.pensum.factory;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator; 

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.factory.MeDataMachineSQL;
import cz.luboss.medulla.factory.MeParamSQL;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.gener.*;
import cz.luboss.pensum.common.*;

/**
	* SQL tovarna pro business funkce Pensum
	*
	* @author LKC
*/
public class PeDataMachineSQL extends MeDataMachineSQL implements PeDataMachine {
	
	/**
	 * Zaloguje uzivatele a vrati jeho session
	 *
	 * @param  sLogin     login uzivatele
	 * @param  sPassword  heslo uzivatele
	 * @return            vytvorena Session
	 */
	public MeSession LoadSession(String sLogin, String sPassword) {
		PeSession sess = null;
    // zkusime 
		String sSQLQuery = "SELECT peworker_id FROM peworker WHERE wklogin = '" + sLogin + "' and wkpassword = '" + sPassword + "'";
		try {
			// naplnime
			Statement stm = m_dtConnectSQL.GetDB().GetConect().createStatement();
      
      // zalogujeme DEBBUG
      PensumContext.logDebug(this.getClass(), "SQL Query : " + sSQLQuery);

			ResultSet rs = stm.executeQuery(sSQLQuery);
			// naplnime objekt
			if (rs.next()) {
        // vytvorime workera
        int nPlatnost = Integer.valueOf(PensumContext.getConfParam(PeConfig.VALID_TIME)).intValue();
        Calendar rightNow = Calendar.getInstance();
        rightNow.add(Calendar.MINUTE, nPlatnost);
        // a naplnime session
        sess = PeSession.CreateInstance(rs.getInt("peworker_id"), new Date(), rightNow.getTime());
			} else {
        return null;
      }
			rs.close();
			stm.close();
		}
		catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "LoadSession Error [" + sSQLQuery + "]", e);
		}
		return sess;
	}

	/** Vytvo nov objet */
	public static PeDataMachineSQL CreateInstance(MeParamSQL param) {
		PeDataMachineSQL machine = new PeDataMachineSQL();
    machine.setParamSQL(param);
		return machine;  
	}

	/**
	  * Prida vyrobek do jobu
	  *
	  * @param nSessionID Session
	  * @param job job, do ktereho je treba dat cely vyrobek
	  * @param product vkladany vyrobek
	  * @return prubeh funkce
	*/
	public boolean AddProduct(int nSessionID, PeJob job, PeProduct product) {
    // zalogujeme DEBBUG
    PensumContext.logDebug(this.getClass(), "AddProduct PeJob [" + job.getID() + "], PeProduct [" 
      + product.getID() + "] .");

    // vytvorime bezici prvek
		PeRunProduct runProduct = PeRunProduct.createInstance();
		runProduct.setPeJob(job);
		runProduct.setPeProduct(product);
		// vsechny jeho dilce
		for (Iterator iter = product.getProductPartArray().iterator(); iter.hasNext();) {
			PePart part = (PePart) ((PeProductPart) iter.next()).getPePart();
			// vytvorime bezici dilec
			PeRunPart runPart = PeRunPart.createInstance();
			runPart.setPeRunproduct(runProduct);
			runPart.setPePart(part);
			// vsechny jeho operace
			for (Iterator iterOper = part.getOperArray().iterator(); iterOper.hasNext();) {
				PeOperation oper = (PeOperation) iterOper.next();
				// vytvorime bezici operaci
				PeRunOperation runOper = PeRunOperation.createInstance();
				runOper.setPeRunpart(part);
				runOper.setPeOperation(oper);
			}
		}
		return true;
	}
	
	/**
	  * Nastavi na produktu a jeho dilcich stav   
	  *
	  * @param nSessionID Session
	  * @param product vyrobek
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavProduct(int nSessionID, PeRunProduct product, int nStav) {
    // zalogujeme DEBBUG
    PensumContext.logDebug(this.getClass(), "SetStavProduct PeRunProduct [" + product.getID() 
      + "], stav [" + nStav + "] .");

    for (Iterator iter = product.getRunPartArray().iterator(); iter.hasNext();) {
			SetStavPart(nSessionID, (PeRunPart) iter.next(), nStav);
		}
		return true;
	}

	/**
	  * Nastavi na dilci a jeho operacich stav
	  *
	  * @param nSessionID Session
	  * @param part dilec
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavPart(int nSessionID, PeRunPart part, int nStav) {
    // zalogujeme DEBBUG
    PensumContext.logDebug(this.getClass(), "SetStavPart PeRunPart [" + part.getID() 
      + "], stav [" + nStav + "] .");

    for (Iterator iter = part.getRunOperArray().iterator(); iter.hasNext();) {
			SetStavOper(nSessionID, (PeRunOperation) iter.next(), nStav);
		}
		return true;
	}

	/**
	  * Nastavi na operaci stav
	  *
	  * @param nSessionID Session
	  * @param operation operace
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavOper(int nSessionID, PeRunOperation operation, int nStav) {
    // zalogujeme DEBBUG
    PensumContext.logDebug(this.getClass(), "SetStavOper PeRunOperation [" + operation.getID() 
      + "], stav [" + nStav + "] .");

    ((MeFieldREF) operation.getParam("rostav")).SetRefID(nStav);
		return true;
	}

}
