package cz.luboss.pensum.factory;

import java.rmi.RemoteException;

// definice
import cz.luboss.medulla.factory.MedullaRMI;

// implementace
import cz.luboss.pensum.gener.PeJob;
import cz.luboss.pensum.gener.PeProduct;
import cz.luboss.pensum.gener.PeRunProduct;
import cz.luboss.pensum.gener.PeRunPart;
import cz.luboss.pensum.gener.PeRunOperation;

/**
	* RMI interface pro business funkce Pensum
	*
	* @author LKC
*/
public interface PensumRMI extends MedullaRMI {

	/**
	  * Prida vyrobek do jobu
	  *
	  * @param nSessionID Session
	  * @param job job, do ktereho je treba dat cely vyrobek
	  * @param product vkladany vyrobek
	  * @return prubeh funkce
	*/
	public boolean AddProduct(int nSessionID, PeJob job, PeProduct product) throws RemoteException;

	/**
	  * Nastavi na produktu a jeho dilcich stav   
	  *
	  * @param nSessionID Session
	  * @param product vyrobek
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavProduct(int nSessionID, PeRunProduct product, int nStav) throws RemoteException;

	/**
	  * Nastavi na dilci a jeho operacich stav
	  *
	  * @param nSessionID Session
	  * @param part dilec
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavPart(int nSessionID, PeRunPart part, int nStav) throws RemoteException;

	/**
	  * Nastavi na operaci stav
	  *
	  * @param nSessionID Session
	  * @param operation operace
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavOper(int nSessionID, PeRunOperation operation, int nStav) throws RemoteException;

}