
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Material (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:57</b>
	*
	* @author Spinster Generator
*/
public class PeMaterial extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT pematerial_id = MeFieldINT.createInstance("pematerial_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldSTRING majmeno = MeFieldSTRING.createInstance("majmeno", "", true);
	MeFieldFLOAT macenaprod = MeFieldFLOAT.createInstance("macenaprod", 0, true);
	MeFieldFLOAT majednotka = MeFieldFLOAT.createInstance("majednotka", 0, true);
	MeFieldFLOAT mahmotnost = MeFieldFLOAT.createInstance("mahmotnost", 0, true);
	MeFieldSTRING madodavatel = MeFieldSTRING.createInstance("madodavatel", "", true);


	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeMaterial createInstance() {
		PeMaterial newItem = new PeMaterial();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeMaterial.m_mapDescParam = new HashMap();
			PeMaterial.m_mapDescParam.put("pematerial_id", "GRID_POL_ID");
			PeMaterial.m_mapDescParam.put("majmeno", "GRID_POL_JMENO");
			PeMaterial.m_mapDescParam.put("macenaprod", "GRID_POL_CENA");
			PeMaterial.m_mapDescParam.put("majednotka", "GRID_POL_JEDNOTKA");
			PeMaterial.m_mapDescParam.put("mahmotnost", "GRID_POL_HMOTNOST");
			PeMaterial.m_mapDescParam.put("madodavatel", "GRID_POL_DODAVATEL");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeMaterial createInstance(int nID) {
		PeMaterial newItem = PeMaterial.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return pematerial_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "pematerial_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.pematerial_id = ((PeMaterial) zdroj).pematerial_id;
		this.majmeno = ((PeMaterial) zdroj).majmeno;
		this.macenaprod = ((PeMaterial) zdroj).macenaprod;
		this.majednotka = ((PeMaterial) zdroj).majednotka;
		this.mahmotnost = ((PeMaterial) zdroj).mahmotnost;
		this.madodavatel = ((PeMaterial) zdroj).madodavatel;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 6;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return pematerial_id;
		} else if (nRow == 1) {
			return majmeno;
		} else if (nRow == 2) {
			return macenaprod;
		} else if (nRow == 3) {
			return majednotka;
		} else if (nRow == 4) {
			return mahmotnost;
		} else if (nRow == 5) {
			return madodavatel;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("pematerial_id")) {
			return pematerial_id;
		} else if (sName.equals("majmeno")) {
			return majmeno;
		} else if (sName.equals("macenaprod")) {
			return macenaprod;
		} else if (sName.equals("majednotka")) {
			return majednotka;
		} else if (sName.equals("mahmotnost")) {
			return mahmotnost;
		} else if (sName.equals("madodavatel")) {
			return madodavatel;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(pematerial_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[6];
		arrColumn[0] = MeColumn.createInstance("pematerial_id", PensumContext.getRes(this.getDesc("pematerial_id")), 20);
		arrColumn[1] = MeColumn.createInstance("majmeno", PensumContext.getRes(this.getDesc("majmeno")), 100);
		arrColumn[2] = MeColumn.createInstance("macenaprod", PensumContext.getRes(this.getDesc("macenaprod")), 150);
		arrColumn[3] = MeColumn.createInstance("majednotka", PensumContext.getRes(this.getDesc("majednotka")), 150);
		arrColumn[4] = MeColumn.createInstance("mahmotnost", PensumContext.getRes(this.getDesc("mahmotnost")), 150);
		arrColumn[5] = MeColumn.createInstance("madodavatel", PensumContext.getRes(this.getDesc("madodavatel")), 150);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr pematerial_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeMaterial() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.pematerial_id.GetInt();
	}

	/**
	  * Nastavi parametr pematerial_id  
	  *
	  * @param pematerial_id hodnota parametru
	*/
	public void setPeMaterial(int pematerial_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pematerial_id.SetInt(pematerial_id_temp);
	}
	/**
	  * Vrati hodnotu parametr majmeno  
	  *
	  * @return hodnota parametru
	*/
	public String getMaJmeno() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.majmeno.GetString();
	}

	/**
	  * Nastavi parametr majmeno  
	  *
	  * @param majmeno hodnota parametru
	*/
	public void setMaJmeno(String majmeno_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.majmeno.SetString(majmeno_temp);
	}
	/**
	  * Vrati hodnotu parametr macenaprod  
	  *
	  * @return hodnota parametru
	*/
	public float getMaCenaprod() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (float) this.macenaprod.GetFloat();
	}

	/**
	  * Nastavi parametr macenaprod  
	  *
	  * @param macenaprod hodnota parametru
	*/
	public void setMaCenaprod(float macenaprod_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.macenaprod.SetFloat(macenaprod_temp);
	}
	/**
	  * Vrati hodnotu parametr majednotka  
	  *
	  * @return hodnota parametru
	*/
	public float getMaJednotka() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (float) this.majednotka.GetFloat();
	}

	/**
	  * Nastavi parametr majednotka  
	  *
	  * @param majednotka hodnota parametru
	*/
	public void setMaJednotka(float majednotka_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.majednotka.SetFloat(majednotka_temp);
	}
	/**
	  * Vrati hodnotu parametr mahmotnost  
	  *
	  * @return hodnota parametru
	*/
	public float getMaHmotnost() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (float) this.mahmotnost.GetFloat();
	}

	/**
	  * Nastavi parametr mahmotnost  
	  *
	  * @param mahmotnost hodnota parametru
	*/
	public void setMaHmotnost(float mahmotnost_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.mahmotnost.SetFloat(mahmotnost_temp);
	}
	/**
	  * Vrati hodnotu parametr madodavatel  
	  *
	  * @return hodnota parametru
	*/
	public String getMaDodavatel() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.madodavatel.GetString();
	}

	/**
	  * Nastavi parametr madodavatel  
	  *
	  * @param madodavatel hodnota parametru
	*/
	public void setMaDodavatel(String madodavatel_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.madodavatel.SetString(madodavatel_temp);
	}

}
