
package cz.luboss.pensum.gener;

// definice
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.factory.MeParamSQL;

/**
	* Trida obsahujici SQL prikazy pro vsechny MeItem a MeArray<p>
	* Vygenerovano <b>22.08.2004 14:29:00</b>
	*
	* @author Spinster Generator
*/
public class PeParamSQL_MySQL implements MeParamSQL {

	/** 
	 * Vytvori novy objekt
	 * 
	 * @return viz popis
	*/
	public static PeParamSQL_MySQL createInstance() {
    PeParamSQL_MySQL param = new PeParamSQL_MySQL();
    return param;
  }

	/**
		* Vrati SELECT string
		*
		* @return viz popis metody
	*/
	public String getSQL_SELECT(MeItem item) {
	  if (item instanceof PeJob) {
			return "SELECT pejob_id, jojmeno, jovytvoren, jopopis, johotovo, jorozpracovano, jozalozeno FROM pejob WHERE 1 = 1";
		} else if (item instanceof PeMaterial) {
			return "SELECT pematerial_id, majmeno, macenaprod, majednotka, mahmotnost, madodavatel FROM pematerial WHERE 1 = 1";
		} else if (item instanceof PeOperation) {
			return "SELECT peoperation_id, peplace_id, pepart_id, opjmeno, optime, opmzda FROM peoperation WHERE 1 = 1";
		} else if (item instanceof PePart) {
			return "SELECT pepart_id, ptjmeno, ptsirka, ptdelka, pthloubka, ptpozn FROM pepart WHERE 1 = 1 ";
		} else if (item instanceof PePartMaterial) {
			return "SELECT pepart_material_id, pepart_id, pematerial_id, pmpocet FROM pepart_material WHERE 1 = 1 ";
		} else if (item instanceof PePlace) {
			return "SELECT peplace_id, parent_id, pljmeno FROM peplace WHERE 1 = 1 ";
		} else if (item instanceof PeProduct) {
			return "SELECT peproduct_id, pojmeno, potyp, posklad FROM peproduct WHERE 1 = 1 ";
		} else if (item instanceof PeProductPart) {
			return "SELECT peproduct_part_id, peproduct_id, pepart_id FROM peproduct_part WHERE 1 = 1 ";
		} else if (item instanceof PeRunOperation) {
			return "SELECT perunoperation_id, peoperation_id, perunpart_id, peworker_id, rostav, rotime FROM perunoperation WHERE 1 = 1 ";
		} else if (item instanceof PeRunPart) {
			return "SELECT perunpart_id, petask_id, perunproduct_id, pepart_id, rpstav, rppozn FROM perunpart WHERE 1 = 1 ";
		} else if (item instanceof PeRunProduct) {
			return "SELECT perunproduct_id, peproduct_id, pejob_id, pdcena  FROM perunproduct WHERE 1 = 1 ";
		} else if (item instanceof PeScrap) {
			return "SELECT pescrap_id, perunoperation_id, perunpart_id, peworker_id, scpozn, sccreate FROM pescrap WHERE 1 = 1 ";
		} else if (item instanceof PeTask) {
			return "SELECT petask_id, parent_id, tajmeno, tavytvoren, tastav FROM petask WHERE 1 = 1 ";
		} else if (item instanceof PeWorker) {
			return "SELECT peworker_id, wkjmeno, wkprijmeni, wkpozn, wkrc, wklogin, wkpassword, wklang FROM peworker WHERE 1 = 1 ";
		} else if (item instanceof PeStatus) {
			return "SELECT pestatus_id, stjmeno, stpopis FROM pestatus WHERE 1 = 1 ";
		} else if (item instanceof PeSession) {
			return "SELECT pesession_id, ssworker, ssplatnost_od, ssplatnost_do, ssrunlog FROM pesession WHERE 1 = 1 ";
		} else {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "Trida " + item + " nema spravne vygenerovanou funkci getSQL_SELECT.");
    }
	}

	/**
		* Vrati SELECT string
		*
		* @return viz popis metody
	*/
	public String getSQL_SELECT(MeArray array) {
    if (array instanceof PeJobArray) {
			return "SELECT pejob_id, jojmeno, jovytvoren, jopopis, johotovo, jorozpracovano, jozalozeno FROM pejob WHERE 1 = 1";
		} else if (array instanceof PeMaterialArray) {
			return "SELECT pematerial_id, majmeno, macenaprod, majednotka, mahmotnost, madodavatel FROM pematerial WHERE 1 = 1";
		} else if (array instanceof PeOperationArray) {
			return "SELECT peoperation_id, peplace_id, pepart_id, opjmeno, optime, opmzda FROM peoperation WHERE 1 = 1";
		} else if (array instanceof PePartArray) {
			return "SELECT pepart_id, ptjmeno, ptsirka, ptdelka, pthloubka, ptpozn FROM pepart WHERE 1 = 1 ";
		} else if (array instanceof PePartMaterialArray) {
			return "SELECT pepart_material_id, pepart_id, pematerial_id, pmpocet FROM pepart_material WHERE 1 = 1 ";
		} else if (array instanceof PePlaceArray) {
			return "SELECT peplace_id, parent_id, pljmeno FROM peplace WHERE 1 = 1 ";
		} else if (array instanceof PeProductArray) {
			return "SELECT peproduct_id, pojmeno, potyp, posklad FROM peproduct WHERE 1 = 1 ";
		} else if (array instanceof PeProductPartArray) {
			return "SELECT peproduct_part_id, peproduct_id, pepart_id FROM peproduct_part WHERE 1 = 1 ";
		} else if (array instanceof PeRunOperationArray) {
			return "SELECT perunoperation_id, peoperation_id, perunpart_id, peworker_id, rostav, rotime FROM perunoperation WHERE 1 = 1 ";
		} else if (array instanceof PeRunPartArray) {
			return "SELECT perunpart_id, petask_id, perunproduct_id, pepart_id, rpstav, rppozn FROM perunpart WHERE 1 = 1 ";
		} else if (array instanceof PeRunProductArray) {
			return "SELECT perunproduct_id, peproduct_id, pejob_id, pdcena  FROM perunproduct WHERE 1 = 1 ";
		} else if (array instanceof PeScrapArray) {
			return "SELECT pescrap_id, perunoperation_id, perunpart_id, peworker_id, scpozn, sccreate FROM pescrap WHERE 1 = 1 ";
		} else if (array instanceof PeTaskArray) {
			return "SELECT petask_id, parent_id, tajmeno, tavytvoren, tastav FROM petask WHERE 1 = 1 ";
		} else if (array instanceof PeWorkerArray) {
			return "SELECT peworker_id, wkjmeno, wkprijmeni, wkpozn, wkrc, wklogin, wkpassword, wklang FROM peworker WHERE 1 = 1 ";
		} else if (array instanceof PeStatusArray) {
			return "SELECT pestatus_id, stjmeno, stpopis FROM pestatus WHERE 1 = 1 ";
		} else if (array instanceof PeSessionArray) {
			return "SELECT pesession_id, ssworker, ssplatnost_od, ssplatnost_do, ssrunlog FROM pesession WHERE 1 = 1 ";
		} else if (array instanceof MeUniArray) {
      return "Pole MeUniArray nema SQL prikaz pro plneni!";
 		} else if (array instanceof MeUniSQLArray) {
      return ((MeUniSQLArray) array).getSQL_SELECT();
 		} else {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "Pole " + array + " nema spravne vygenerovanou funkci getSQL_SELECT.");
    }
	}

	/**
		* Tabulky pro INSERT a UPDATE
		*
		* @return viz popis metody
	*/
	public String getSQL_INSERT(MeItem item) {
	  if (item instanceof PeJob) {
			return "pejob";
		} else if (item instanceof PeMaterial) {
			return "pematerial";
		} else if (item instanceof PeOperation) {
			return "peoperation";
		} else if (item instanceof PePart) {
			return "pepart";
		} else if (item instanceof PePartMaterial) {
			return "pepart_material";
		} else if (item instanceof PePlace) {
			return "peplace";
		} else if (item instanceof PeProduct) {
			return "peproduct";
		} else if (item instanceof PeProductPart) {
			return "peproduct_part";
		} else if (item instanceof PeRunOperation) {
			return "perunoperation";
		} else if (item instanceof PeRunPart) {
			return "perunpart";
		} else if (item instanceof PeRunProduct) {
			return "perunproduct";
		} else if (item instanceof PeScrap) {
			return "pescrap";
		} else if (item instanceof PeTask) {
			return "petask";
		} else if (item instanceof PeWorker) {
			return "peworker";
		} else if (item instanceof PeStatus) {
			return "pestatus";
		} else if (item instanceof PeSession) {
			return "pesession";
		} else {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "Trida " + item + " nema spravne vygenerovanou funkci getSQL_INSERT.");
    }
	}
	
  /**
		* Selectovaci stringy pro vyberovy dialog
		*
		* @return viz popis metody
	*/
	public String getSelectSQL(MeItem item) {
	  if (item instanceof PeJob) {
			return "SELECT pejob_id, jojmeno FROM pejob";
		} else if (item instanceof PeMaterial) {
			return "SELECT pematerial_id, majmeno FROM pematerial";
		} else if (item instanceof PeOperation) {
			return "SELECT peoperation_id, opjmeno FROM peoperation";
		} else if (item instanceof PePart) {
			return "SELECT pepart_id, ptjmeno FROM pepart";
		} else if (item instanceof PePartMaterial) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PePartMaterial nema vyberovy SELECT.");
		} else if (item instanceof PePlace) {
			return "SELECT peplace_id, pljmeno FROM peplace ";
		} else if (item instanceof PeProduct) {
			return "SELECT peproduct_id, pojmeno FROM peproduct ";
		} else if (item instanceof PeProductPart) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeProductPart nema vyberovy SELECT.");
		} else if (item instanceof PeRunOperation) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeRunOperation nema vyberovy SELECT.");
		} else if (item instanceof PeRunPart) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeRunPart nema vyberovy SELECT.");
		} else if (item instanceof PeRunProduct) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeRunProduct nema vyberovy SELECT.");
		} else if (item instanceof PeScrap) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeScrap nema vyberovy SELECT.");
		} else if (item instanceof PeTask) {
			return "SELECT petask_id, tajmeno FROM petask ";
		} else if (item instanceof PeWorker) {
			return "SELECT peworker_id, concat(wkjmeno, ' ', wkprijmeni) FROM peworker ";
		} else if (item instanceof PeStatus) {
			return "SELECT pestatus_id, stjmeno FROM pestatus WHERE 1 = 1 ";
		} else if (item instanceof PeSession) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeSession nema vyberovy SELECT.");
		} else {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "Trida " + item + " nema spravne vygenerovanou funkci getSelectSQL.");
    }
	}

	/**
		* Jmena polozek pro vyberovy dialog
		*
		* @return viz popis metody
	*/
	public String[] getSelectFields(MeItem item) {
	  if (item instanceof PeJob) {
			String[] arrPopisy = new String[2];
			arrPopisy[0] = "GRID_POL_ID";
			arrPopisy[1] = "GRID_POL_JMENO";
			return arrPopisy;
		} else if (item instanceof PeMaterial) {
			String[] arrPopisy = new String[2];
			arrPopisy[0] = "GRID_POL_ID";
			arrPopisy[1] = "GRID_POL_JMENO";
			return arrPopisy;
		} else if (item instanceof PeOperation) {
			String[] arrPopisy = new String[2];
			arrPopisy[0] = "GRID_POL_ID";
			arrPopisy[1] = "GRID_POL_JMENO";
			return arrPopisy;
		} else if (item instanceof PePart) {
			String[] arrPopisy = new String[2];
			arrPopisy[0] = "GRID_POL_ID";
			arrPopisy[1] = "GRID_POL_JMENO";
			return arrPopisy;
		} else if (item instanceof PePartMaterial) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PePartMaterial nema polozky pro vyberovy SELECT.");
		} else if (item instanceof PePlace) {
			String[] arrPopisy = new String[2];
			arrPopisy[0] = "GRID_POL_ID";
			arrPopisy[1] = "GRID_POL_JMENO";
			return arrPopisy;
		} else if (item instanceof PeProduct) {
			String[] arrPopisy = new String[2];
			arrPopisy[0] = "GRID_POL_ID";
			arrPopisy[1] = "GRID_POL_JMENO";
			return arrPopisy;
		} else if (item instanceof PeProductPart) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeProductPart nema polozky pro vyberovy SELECT.");
		} else if (item instanceof PeRunOperation) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeRunOperation nema polozky pro vyberovy SELECT.");
		} else if (item instanceof PeRunPart) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeRunPart nema polozky pro vyberovy SELECT.");
		} else if (item instanceof PeRunProduct) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeRunProduct nema polozky pro vyberovy SELECT.");
		} else if (item instanceof PeScrap) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeScrap nema polozky pro vyberovy SELECT.");
		} else if (item instanceof PeTask) {
			String[] arrPopisy = new String[2];
			arrPopisy[0] = "GRID_POL_ID";
			arrPopisy[1] = "GRID_POL_JMENO";
			return arrPopisy;
		} else if (item instanceof PeWorker) {
			String[] arrPopisy = new String[2];
			arrPopisy[0] = "GRID_POL_ID";
			arrPopisy[1] = "GRID_POL_JMENO";
			return arrPopisy;
		} else if (item instanceof PeStatus) {
			String[] arrPopisy = new String[2];
			arrPopisy[0] = "GRID_POL_ID";
			arrPopisy[1] = "GRID_POL_JMENO";
			return arrPopisy;
		} else if (item instanceof PeSession) {
			throw new cz.luboss.lubosslib.LException(this.getClass(), "Prvek tridy PeSession nema polozky pro vyberovy SELECT.");
		} else {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "Trida " + item + " nema spravne vygenerovanou funkci getSelectFields.");
    }
	}

	/**
		* Vrati databazovy ovladac
		*
		* @return viz popis metody
	*/
	public String getDriver() {
    return "org.gjt.mm.mysql.Driver";
  }
	
  /**
		* Vrati tabulku se seqencemi ID pro ostatni tabulky
		*
		* @return viz popis metody
	*/
	public String getSequence() {
    return "pesequence";
  }

}
