
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Jeden bezici dilec (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:59</b>
	*
	* @author Spinster Generator
*/
public class PeRunPart extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT perunpart_id = MeFieldINT.createInstance("perunpart_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldREF petask_id = MeFieldREF.createInstance("petask_id", PeTask.class, "tajmeno", 0, true);
	MeFieldREF perunproduct_id = MeFieldREF.createInstance("perunproduct_id", PeRunProduct.class, "peproduct_id", 0, false);
	MeFieldREF pepart_id = MeFieldREF.createInstance("pepart_id", PePart.class, "ptjmeno", 0, false);
	MeFieldREF rpstav = MeFieldREF.createInstance("rpstav", PeStatus.class, "stjmeno", 0, false);
	MeFieldSTRING rppozn = MeFieldSTRING.createInstance("rppozn", "", true);

	/** pole operaci na dilci */
	protected PeRunOperationArray m_arrgetRunOperArray = null;

	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeRunPart createInstance() {
		PeRunPart newItem = new PeRunPart();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeRunPart.m_mapDescParam = new HashMap();
			PeRunPart.m_mapDescParam.put("perunpart_id", "GRID_POL_ID");
			PeRunPart.m_mapDescParam.put("petask_id", "GRID_POL_VYR_PRIKAZ");
			PeRunPart.m_mapDescParam.put("perunproduct_id", "GRID_POL_VYROBEK");
			PeRunPart.m_mapDescParam.put("pepart_id", "GRID_POL_POPIS_DILCE");
			PeRunPart.m_mapDescParam.put("rpstav", "GRID_POL_STAV");
			PeRunPart.m_mapDescParam.put("rppozn", "GRID_POL_POZNAMKA");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeRunPart createInstance(int nID) {
		PeRunPart newItem = PeRunPart.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return perunpart_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "perunpart_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.perunpart_id = ((PeRunPart) zdroj).perunpart_id;
		this.petask_id = ((PeRunPart) zdroj).petask_id;
		this.perunproduct_id = ((PeRunPart) zdroj).perunproduct_id;
		this.pepart_id = ((PeRunPart) zdroj).pepart_id;
		this.rpstav = ((PeRunPart) zdroj).rpstav;
		this.rppozn = ((PeRunPart) zdroj).rppozn;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 6;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return perunpart_id;
		} else if (nRow == 1) {
			return petask_id;
		} else if (nRow == 2) {
			return perunproduct_id;
		} else if (nRow == 3) {
			return pepart_id;
		} else if (nRow == 4) {
			return rpstav;
		} else if (nRow == 5) {
			return rppozn;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("perunpart_id")) {
			return perunpart_id;
		} else if (sName.equals("petask_id")) {
			return petask_id;
		} else if (sName.equals("perunproduct_id")) {
			return perunproduct_id;
		} else if (sName.equals("pepart_id")) {
			return pepart_id;
		} else if (sName.equals("rpstav")) {
			return rpstav;
		} else if (sName.equals("rppozn")) {
			return rppozn;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(perunpart_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////
	/**
	 	* Vrati pole operaci na dilci, pokud neexistuje, vytvorime
	 	*
	 	* @return viz popis metody
	*/
	public PeRunOperationArray getRunOperArray() {
		// pokud pole neni naplneno
		if (m_arrgetRunOperArray == null) {
			m_arrgetRunOperArray = PeRunOperationArray.createInstance();
			m_arrgetRunOperArray.loadArray(MePodminka.createInstance("perunpart_id", this.getID()));
		}
		return m_arrgetRunOperArray;
	}

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[6];
		arrColumn[0] = MeColumn.createInstance("perunpart_id", PensumContext.getRes(this.getDesc("perunpart_id")), 20);
		arrColumn[1] = MeColumn.createInstance("petask_id", PensumContext.getRes(this.getDesc("petask_id")), 80);
		arrColumn[2] = MeColumn.createInstance("perunproduct_id", PensumContext.getRes(this.getDesc("perunproduct_id")), 80);
		arrColumn[3] = MeColumn.createInstance("pepart_id", PensumContext.getRes(this.getDesc("pepart_id")), 100);
		arrColumn[4] = MeColumn.createInstance("rpstav", PensumContext.getRes(this.getDesc("rpstav")), 50);
		arrColumn[5] = MeColumn.createInstance("rppozn", PensumContext.getRes(this.getDesc("rppozn")), 80);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr perunpart_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeRunpart() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.perunpart_id.GetInt();
	}

	/**
	  * Nastavi parametr perunpart_id  
	  *
	  * @param perunpart_id hodnota parametru
	*/
	public void setPeRunpart(int perunpart_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.perunpart_id.SetInt(perunpart_id_temp);
	}
	/**
	  * Vrati hodnotu parametr petask_id  
	  *
	  * @return hodnota parametru
	*/
	public PeTask getPeTask() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeTask) this.petask_id.GetRef();
	}

	/**
	  * Nastavi parametr petask_id  
	  *
	  * @param petask_id hodnota parametru
	*/
	public void setPeTask(PeTask petask_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.petask_id.SetRef(petask_id_temp);
	}
	/**
	  * Vrati hodnotu parametr perunproduct_id  
	  *
	  * @return hodnota parametru
	*/
	public PeRunProduct getPeRunproduct() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeRunProduct) this.perunproduct_id.GetRef();
	}

	/**
	  * Nastavi parametr perunproduct_id  
	  *
	  * @param perunproduct_id hodnota parametru
	*/
	public void setPeRunproduct(PeRunProduct perunproduct_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.perunproduct_id.SetRef(perunproduct_id_temp);
	}
	/**
	  * Vrati hodnotu parametr pepart_id  
	  *
	  * @return hodnota parametru
	*/
	public PePart getPePart() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PePart) this.pepart_id.GetRef();
	}

	/**
	  * Nastavi parametr pepart_id  
	  *
	  * @param pepart_id hodnota parametru
	*/
	public void setPePart(PePart pepart_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pepart_id.SetRef(pepart_id_temp);
	}
	/**
	  * Vrati hodnotu parametr rpstav  
	  *
	  * @return hodnota parametru
	*/
	public PeStatus getRpStav() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeStatus) this.rpstav.GetRef();
	}

	/**
	  * Nastavi parametr rpstav  
	  *
	  * @param rpstav hodnota parametru
	*/
	public void setRpStav(PeStatus rpstav_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.rpstav.SetRef(rpstav_temp);
	}
	/**
	  * Vrati hodnotu parametr rppozn  
	  *
	  * @return hodnota parametru
	*/
	public String getRpPozn() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.rppozn.GetString();
	}

	/**
	  * Nastavi parametr rppozn  
	  *
	  * @param rppozn hodnota parametru
	*/
	public void setRpPozn(String rppozn_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.rppozn.SetString(rppozn_temp);
	}

}
