
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Pracovnik (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:29:00</b>
	*
	* @author Spinster Generator
*/
public class PeWorker extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT peworker_id = MeFieldINT.createInstance("peworker_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldSTRING wkjmeno = MeFieldSTRING.createInstance("wkjmeno", "", true);
	MeFieldSTRING wkprijmeni = MeFieldSTRING.createInstance("wkprijmeni", "", true);
	MeFieldSTRING wkpozn = MeFieldSTRING.createInstance("wkpozn", "", true);
	MeFieldSTRING wkrc = MeFieldSTRING.createInstance("wkrc", "", true);
	MeFieldSTRING wklogin = MeFieldSTRING.createInstance("wklogin", "", true);
	MeFieldSTRING wkpassword = MeFieldSTRING.createInstance("wkpassword", "", true);
	MeFieldINT wklang = MeFieldINT.createInstance("wklang", 0, true);


	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeWorker createInstance() {
		PeWorker newItem = new PeWorker();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeWorker.m_mapDescParam = new HashMap();
			PeWorker.m_mapDescParam.put("peworker_id", "GRID_POL_ID");
			PeWorker.m_mapDescParam.put("wkjmeno", "GRID_POL_JMENO");
			PeWorker.m_mapDescParam.put("wkprijmeni", "GRID_POL_PRIJMENI");
			PeWorker.m_mapDescParam.put("wkpozn", "GRID_POL_POZNAMKA");
			PeWorker.m_mapDescParam.put("wkrc", "GRID_POL_RC");
			PeWorker.m_mapDescParam.put("wklogin", "GRID_POL_LOGIN");
			PeWorker.m_mapDescParam.put("wkpassword", "GRID_POL_HESLO");
			PeWorker.m_mapDescParam.put("wklang", "GRID_POL_JAZYK");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeWorker createInstance(int nID) {
		PeWorker newItem = PeWorker.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return peworker_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "peworker_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.peworker_id = ((PeWorker) zdroj).peworker_id;
		this.wkjmeno = ((PeWorker) zdroj).wkjmeno;
		this.wkprijmeni = ((PeWorker) zdroj).wkprijmeni;
		this.wkpozn = ((PeWorker) zdroj).wkpozn;
		this.wkrc = ((PeWorker) zdroj).wkrc;
		this.wklogin = ((PeWorker) zdroj).wklogin;
		this.wkpassword = ((PeWorker) zdroj).wkpassword;
		this.wklang = ((PeWorker) zdroj).wklang;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 8;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return peworker_id;
		} else if (nRow == 1) {
			return wkjmeno;
		} else if (nRow == 2) {
			return wkprijmeni;
		} else if (nRow == 3) {
			return wkpozn;
		} else if (nRow == 4) {
			return wkrc;
		} else if (nRow == 5) {
			return wklogin;
		} else if (nRow == 6) {
			return wkpassword;
		} else if (nRow == 7) {
			return wklang;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("peworker_id")) {
			return peworker_id;
		} else if (sName.equals("wkjmeno")) {
			return wkjmeno;
		} else if (sName.equals("wkprijmeni")) {
			return wkprijmeni;
		} else if (sName.equals("wkpozn")) {
			return wkpozn;
		} else if (sName.equals("wkrc")) {
			return wkrc;
		} else if (sName.equals("wklogin")) {
			return wklogin;
		} else if (sName.equals("wkpassword")) {
			return wkpassword;
		} else if (sName.equals("wklang")) {
			return wklang;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(peworker_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[7];
		arrColumn[0] = MeColumn.createInstance("peworker_id", PensumContext.getRes(this.getDesc("peworker_id")), 30);
		arrColumn[1] = MeColumn.createInstance("wkjmeno", PensumContext.getRes(this.getDesc("wkjmeno")), 150);
		arrColumn[2] = MeColumn.createInstance("wkprijmeni", PensumContext.getRes(this.getDesc("wkprijmeni")), 150);
		arrColumn[3] = MeColumn.createInstance("wkpozn", PensumContext.getRes(this.getDesc("wkpozn")), 200);
		arrColumn[4] = MeColumn.createInstance("wkrc", PensumContext.getRes(this.getDesc("wkrc")), 80);
		arrColumn[5] = MeColumn.createInstance("wklogin", PensumContext.getRes(this.getDesc("wklogin")), 80);
		arrColumn[6] = MeColumn.createInstance("wkpassword", PensumContext.getRes(this.getDesc("wkpassword")), 80);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr peworker_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeWorker() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.peworker_id.GetInt();
	}

	/**
	  * Nastavi parametr peworker_id  
	  *
	  * @param peworker_id hodnota parametru
	*/
	public void setPeWorker(int peworker_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.peworker_id.SetInt(peworker_id_temp);
	}
	/**
	  * Vrati hodnotu parametr wkjmeno  
	  *
	  * @return hodnota parametru
	*/
	public String getWkJmeno() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.wkjmeno.GetString();
	}

	/**
	  * Nastavi parametr wkjmeno  
	  *
	  * @param wkjmeno hodnota parametru
	*/
	public void setWkJmeno(String wkjmeno_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.wkjmeno.SetString(wkjmeno_temp);
	}
	/**
	  * Vrati hodnotu parametr wkprijmeni  
	  *
	  * @return hodnota parametru
	*/
	public String getWkPrijmeni() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.wkprijmeni.GetString();
	}

	/**
	  * Nastavi parametr wkprijmeni  
	  *
	  * @param wkprijmeni hodnota parametru
	*/
	public void setWkPrijmeni(String wkprijmeni_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.wkprijmeni.SetString(wkprijmeni_temp);
	}
	/**
	  * Vrati hodnotu parametr wkpozn  
	  *
	  * @return hodnota parametru
	*/
	public String getWkPozn() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.wkpozn.GetString();
	}

	/**
	  * Nastavi parametr wkpozn  
	  *
	  * @param wkpozn hodnota parametru
	*/
	public void setWkPozn(String wkpozn_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.wkpozn.SetString(wkpozn_temp);
	}
	/**
	  * Vrati hodnotu parametr wkrc  
	  *
	  * @return hodnota parametru
	*/
	public String getWkRc() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.wkrc.GetString();
	}

	/**
	  * Nastavi parametr wkrc  
	  *
	  * @param wkrc hodnota parametru
	*/
	public void setWkRc(String wkrc_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.wkrc.SetString(wkrc_temp);
	}
	/**
	  * Vrati hodnotu parametr wklogin  
	  *
	  * @return hodnota parametru
	*/
	public String getWkLogin() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.wklogin.GetString();
	}

	/**
	  * Nastavi parametr wklogin  
	  *
	  * @param wklogin hodnota parametru
	*/
	public void setWkLogin(String wklogin_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.wklogin.SetString(wklogin_temp);
	}
	/**
	  * Vrati hodnotu parametr wkpassword  
	  *
	  * @return hodnota parametru
	*/
	public String getWkPassword() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.wkpassword.GetString();
	}

	/**
	  * Nastavi parametr wkpassword  
	  *
	  * @param wkpassword hodnota parametru
	*/
	public void setWkPassword(String wkpassword_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.wkpassword.SetString(wkpassword_temp);
	}
	/**
	  * Vrati hodnotu parametr wklang  
	  *
	  * @return hodnota parametru
	*/
	public int getWkLang() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.wklang.GetInt();
	}

	/**
	  * Nastavi parametr wklang  
	  *
	  * @param wklang hodnota parametru
	*/
	public void setWkLang(int wklang_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.wklang.SetInt(wklang_temp);
	}

}
