/*
 * MeLogTest.java
 * JUnit based test
 *
 * Created on 13. srpen 2004, 0:23
 */

package cz.luboss.pensum.junit;

import junit.framework.*;

// Import log4j classes.
import org.apache.log4j.Logger;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.log4j.lf5.DefaultLF5Configurator;

import java.io.IOException;
import java.net.URL;

/**
 * Testy transakci
 *
 * @author LC
 */
public class MeLogTest extends TestCase {
  
  private static Logger logger = Logger.getLogger(MeLogTest.class);

  private static Logger logger1 =
          Logger.getLogger(MeLogTest.class);
  private static Logger logger2 =
          Logger.getLogger("TestClass.Subclass");
  private static Logger logger3 =
          Logger.getLogger("TestClass.Subclass.Subclass");

  /**
   * Spusteni programu
   *
   * @param args parametry
  */
  public static void main(String[] args) {
    junit.textui.TestRunner.run(suite()); 
  }

  /** 
   * Spousteni testu 
   *
   * @return testivaci prostredi
 */
  public static Test suite() {
    TestSuite suite = new TestSuite(MeLogTest.class);
    return suite;
  }
  
  /**
   * Test logu MeLogTest
   */
  public void testMeLogTest() {
    System.out.println("Test logu na MeLogTest");
    // BasicConfigurator replaced with PropertyConfigurator.
    PropertyConfigurator.configure("log4j.cfg");

    Logger.getLogger(MeLogTest.class).info("Entering application.");
    Logger.getLogger(MeLogTest.class).info("Exiting application.");
  }

  /**
   * Test logu Defaultniho logu
   */
  public void testLogDefTest() throws IOException {
//    // Configure the LF5Appender using the DefaultLF5Configurator.  This
//    // will add the LF5Appender to the root of the Category tree.
//    DefaultLF5Configurator.configure();
//
//    // Add an NDC to demonstrate how NDC information is output.
//    NDC.push("#23856");
//    // Log some information.
//    for (int i = 0; i < 10; i++) {
//        logger.debug("Hello, my name is Homer Simpson.");
//        logger.info("Mmmmmm .... Chocolate.");
//        logger.warn("Mmm...forbidden donut.");
//    }
//    // Clean up NDC
//    NDC.pop();
//    NDC.remove();
//
//    NDC.push("Another NDC");
//    // Log some information.
//    logger.fatal("Hello, my name is Bart Simpson.");
//    logger.error("Hi diddly ho good neighbour.");
//    // Clean up NDC
//    NDC.pop();
//    NDC.remove();
//
//    // Call methods on both classes.
//    MeLogTest.foo();
//
//    logger.info("Exiting InitUsingDefaultConfigurator.");
  }
  
  public static void foo() {
    logger.debug("Entered foo in InitUsingDefaultConfigurator class");

    NDC.push("#123456");
    logger.debug("Hello, my name is Marge Simpson.");
    logger.info("D'oh!! A deer! A female deer.");
    // Clean up NDC
    NDC.pop();
    NDC.remove();
  }

  public void testLogSocketTest() throws IOException {
    // Use a PropertyConfigurator to initialize from a property file.
    PropertyConfigurator.configure("G:/Java/jakarta-log4j-1.2.8/examples/lf5/UsingSocketAppenders/socketclient.properties");

    // Add a bunch of logging statements ...
    logger1.debug("Hello, my name is Homer Simpson.");
    logger1.debug("Hello, my name is Lisa Simpson.");
    logger2.debug("Hello, my name is Marge Simpson.");
    logger2.debug("Hello, my name is Bart Simpson.");
    logger3.debug("Hello, my name is Maggie Simpson.");

    logger2.info("We are the Simpsons!");
    logger2.info("Mmmmmm .... Chocolate.");
    logger3.info("Homer likes chocolate");
    logger3.info("Doh!");
    logger3.info("We are the Simpsons!");

    logger1.warn("Bart: I am through with working! Working is for chumps!" +
          "Homer: Son, I'm proud of you. I was twice your age before " +
          "I figured that out.");
    logger1.warn("Mmm...forbidden donut.");
    logger1.warn("D'oh! A deer! A female deer!");
    logger1.warn("Truly, yours is a butt that won't quit." +
          "- Bart, writing as Woodrow to Ms. Krabappel.");

    logger2.error("Dear Baby, Welcome to Dumpsville. Population: you.");
    logger2.error("Dear Baby, Welcome to Dumpsville. Population: you.",
          new IOException("Dumpsville, USA"));
    logger3.error("Mr. Hutz, are you aware you're not wearing pants?");
    logger3.error("Mr. Hutz, are you aware you're not wearing pants?",
          new IllegalStateException("Error !!"));


    logger3.fatal("Eep.");

    logger3.fatal("Mmm...forbidden donut.",
          new SecurityException("Fatal Exception ... "));

    logger3.fatal("D'oh! A deer! A female deer!");
    logger2.fatal("Mmmmmm .... Chocolate.",
          new SecurityException("Fatal Exception"));

    // Put the main thread is put to sleep for 5 seconds to allow the
    // SocketServer to process all incoming messages before the Socket is
    // closed. This is done to overcome some basic limitations with the
    // way the SocketServer and SocketAppender classes manage sockets.
    try {
      Thread.currentThread().sleep(5000);
    } catch (InterruptedException ie) {
    }
  }

}
