package cz.luboss.pensum.server;

// definice
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.common.MePodminka;
import cz.luboss.medulla.common.MeDataTest;

// implementace
import cz.luboss.pensum.common.*;
import cz.luboss.pensum.gener.*;

/**
	* Testy serveru
	*
	* @author LKC
*/
public class TestPeServerRMI {

	public static void main(String[] args) {
		// nastavime Connect SQL
		cz.luboss.medulla.factory.MeDataMachineSQL dataMachine 
      = cz.luboss.pensum.factory.PeDataMachineSQL.CreateInstance(PeParamSQL_MySQL.createInstance());
//		cz.luboss.medulla.factory.MeConnectSQL dbConnect = cz.luboss.medulla.factory.MeConnectSQL.CreateInstance();
//		dataMachine.SetConnect(dbConnect);

		// vytvorime kontext
		PensumContext.CreateInstance("pensum.cfg", MeDefine.DEF_DATAMACHINE_SQL);

		// otestovani prosteho spojeni
		MeDataTest p1 = new MeDataTest(5, "BOB");
		System.out.println("-- Proste spojeni -----------------------------------");
		System.out.println("  Vstup  [" + p1.GetID() + "][" + p1.GetName() + "]");  
		MeDataTest p2 = PensumContext.GetRunMachine().sendTest(p1);
		System.out.println("  Vystup  [" + p2.GetID() + "][" + p2.GetName() + "]");

		System.out.println("-- Jeden prvek --------------------------------------");
		PeJob testJob = (PeJob) PeJob.createInstance();
		testJob.load(1); 
		System.out.println("[ID] ["	
			+ testJob.getParam(0).GetName() + "]["
			+ testJob.getParam(1).GetName()+ "]");			  
		System.out.println("[" + testJob.getID() + "]["
			+ testJob.getParam(0).GetString()+ "]["  
			+ testJob.getParam(1).GetString()+ "]");

		System.out.println("-- Pole ---------------------------------------------");
		PeJobArray testJobArray = PeJobArray.createInstance();
		testJobArray.loadArray(MePodminka.createInstance("pejob_id", MePodminka.VETSI, "0"));
		
		for (int i = 0; i < testJobArray.size(); i++) {
			testJob = (PeJob) testJobArray.getItem(i);
			if (i == 0) {
				System.out.println("[ID] [" 
					+ testJob.getParam(0).GetName() + "]["
					+ testJob.getParam(1).GetName()+ "]");			  
			}
			System.out.println("[" + testJob.getID() + "]["
				+ testJob.getParam(0).GetString()+ "]["  
				+ testJob.getParam(1).GetString()+ "]");
		}
/*
		PeJob testJobNew = PeJob.CreteInstance();
		testJobNew.GetDesc(0).SetString("prd");
		testJobArray.AddItem(testJobNew);
		testJob = (PeJob) testJobArray.GetItem(4);
		testJob.GetDesc(0).SetString("prdel");
		testJobArray.SaveArray();
*/
	
/*
		PeElement testElem = PeElementDB.CreteInstance();
		testElem.sName = "test 1";
		testElem.sDesc = "popis testu 1";
		testJob.GetRunElementArr().AddItem(testElem); 

		testElem = PeElement.Crete();
		testElem.sName = "test 2";
		testElem.sDesc = "popis testu 2";
		testJob.GetRunElementArr().AddItem(testElem); 

		System.out.println("01 [" + ((PeElement)testJob.GetRunElementArr().GetItem(0)).sName + "]");
		System.out.println("02 [" + ((PeElement)testJob.GetRunElementArr().GetItem(1)).sName + "]");
*/	}
}
