/*
 * Decompiled with CFR 0.152.
 */
package cz.luboss.spinster;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Spinster {
    public static String VERSION = "0.3";
    private static SimpleDateFormat m_forDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    public static String DEF_FILE_VZOR = "item.pat";
    public static String DEF_FILE_VZOR_SQLPARAM = "item_sqlparam.pat";
    public static String DEF_FILE_VZOR_SETGETMETODS = "item_setgetmetods.pat";
    public static String DEF_FILE_VZOR_GETCOLUMNS = "item_getcolumns.pat";
    public static String DEF_FILE_VZOR_ARRAY = "item_array.pat";
    public static String DEF_FILE_VZOR_GETSUBARRAY = "item_getsubarray.pat";
    public static int ID_FORM_CLASS_NAME = 0;
    public static int ID_FORM_TABLE_NAME = 1;
    public static int ID_FORM_DATE = 2;
    public static int ID_FORM_FIELDS = 3;
    public static int ID_FORM_SUBARRY = 4;
    public static int ID_FORM_NEGENEROVANO = 5;
    public static int ID_FORM_SETGET_METODS = 6;
    public static int ID_FORM_FIELDS_DESC = 7;
    public static int ID_FORM_ATRIBUTES = 8;
    public static int ID_FORM_PARENT_CLASS = 9;
    public static int ID_FORM_PORADI_ID = 10;
    public static int ID_FORM_NAME_ID = 11;
    public static int ID_FORM_SET_DATA = 12;
    public static int ID_FORM_PARAMETR_COUNT = 13;
    public static int ID_FORM_GET_PARAM_INT = 14;
    public static int ID_FORM_GET_PARAM_STRING = 15;

    public static void main(String[] args) {
        System.out.println("\n");
        System.out.println("Spinster verze " + VERSION + " - Generator JAVA trid pro projekt Medulla");
        System.out.println("\n");
        String sXMLFile = "";
        String sSourceDir = "";
        String sParamClass = "";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("xmlfile=")) {
                sXMLFile = args[i].substring(8, args[i].length());
                continue;
            }
            if (args[i].startsWith("sourcedir=")) {
                sSourceDir = args[i].substring(10, args[i].length());
                continue;
            }
            if (!args[i].startsWith("paramclass=")) continue;
            sParamClass = args[i].substring(11, args[i].length());
        }
        String sError = "";
        if (sXMLFile.length() == 0) {
            sError = sError + "  Spatne zadany vstupni XML soubor!";
        }
        if (sSourceDir.length() == 0) {
            sError = sError + "  Spatne zadany vystupni adresar!";
        }
        if (sError.length() != 0) {
            System.out.println("Zadal jste spatne parametry :");
            System.out.println(sError);
            Spinster.PrintCommnadLine();
            return;
        }
        System.out.println("  Generuje se podle souboru " + sXMLFile + "\n");
        String sFileClassSource = Spinster.LoadFile(DEF_FILE_VZOR);
        if (sFileClassSource == null) {
            System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR + "]");
            Spinster.PrintCommnadLine();
            return;
        }
        String sFileArraySource = Spinster.LoadFile(DEF_FILE_VZOR_ARRAY);
        if (sFileArraySource == null) {
            System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR_ARRAY + "]");
            Spinster.PrintCommnadLine();
            return;
        }
        String sGetSQLParamSource = Spinster.LoadFile(DEF_FILE_VZOR_SQLPARAM);
        if (sGetSQLParamSource == null) {
            System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR_SQLPARAM + "]");
            Spinster.PrintCommnadLine();
            return;
        }
        String sSetGetMetodsSource = Spinster.LoadFile(DEF_FILE_VZOR_SETGETMETODS);
        if (sSetGetMetodsSource == null) {
            System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR_SETGETMETODS + "]");
            Spinster.PrintCommnadLine();
            return;
        }
        String sGetColumnsSource = Spinster.LoadFile(DEF_FILE_VZOR_GETCOLUMNS);
        if (sGetColumnsSource == null) {
            System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR_GETCOLUMNS + "]");
            Spinster.PrintCommnadLine();
            return;
        }
        String sGetSubArraySource = Spinster.LoadFile(DEF_FILE_VZOR_GETSUBARRAY);
        if (sGetSubArraySource == null) {
            System.out.println("Nepodarilo se nahrat temp soubor [" + DEF_FILE_VZOR_GETSUBARRAY + "]");
            Spinster.PrintCommnadLine();
            return;
        }
        String[] arrFormPopisy = new String[16];
        String[] arrSQLPopisy = new String[]{sParamClass, "", "", "", "", "", "", "", ""};
        String sGetSQL_INSERT = "";
        String sGetSQL_SELECT = "";
        String sGetSQL_SELECT_ARRAY = "";
        String sLoadParam = "";
        String sLoadParamDesc = "";
        String sGetSelectSQL = "";
        String sGetSelectFields = "";
        String sViews = "";
        String sSetGetMetods = "";
        String sGetSubArrayItem = "";
        String sGetSubArrayFun = "";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(sXMLFile));
            Element elem = document.getDocumentElement();
            NodeList arrItem = elem.getChildNodes();
            for (int i = 0; i < arrItem.getLength(); ++i) {
                Node item = arrItem.item(i);
                if (item.getNodeType() == 3) continue;
                sGetSQL_INSERT = "";
                sGetSQL_SELECT = "";
                sGetSQL_SELECT_ARRAY = "";
                sLoadParam = "";
                sLoadParamDesc = "";
                sGetSelectSQL = "";
                sGetSelectFields = "";
                sViews = "";
                sSetGetMetods = "";
                sGetSubArrayItem = "";
                sGetSubArrayFun = "";
                String sSetData = "";
                String sGetParamINT = "";
                String sGetParamSTRING = "";
                if (item.getNodeName().equals("DRIVERNAME")) {
                    arrSQLPopisy[7] = item.getFirstChild() == null ? "" : item.getFirstChild().getNodeValue();
                    continue;
                }
                if (item.getNodeName().equals("SEQUENCE_TABLE")) {
                    arrSQLPopisy[8] = item.getFirstChild() == null ? "" : item.getFirstChild().getNodeValue();
                    continue;
                }
                NodeList arrParam = item.getChildNodes();
                for (int j = 0; j < arrParam.getLength(); ++j) {
                    int nViewCount;
                    String sName;
                    Node field;
                    int k;
                    NodeList arrFields;
                    Node param = arrParam.item(j);
                    if (param.getNodeType() == 3) continue;
                    if (param.getNodeName().equals("NAME")) {
                        arrFormPopisy[Spinster.ID_FORM_CLASS_NAME] = param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (param.getNodeName().equals("PARENT")) {
                        arrFormPopisy[Spinster.ID_FORM_PARENT_CLASS] = param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (param.getNodeName().equals("PORADI_ID")) {
                        arrFormPopisy[Spinster.ID_FORM_PORADI_ID] = param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (param.getNodeName().equals("DESCRIPTION")) {
                        arrFormPopisy[Spinster.ID_FORM_TABLE_NAME] = param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (param.getNodeName().equals("INSERT_TABLE")) {
                        sGetSQL_INSERT = "if (item instanceof " + arrFormPopisy[ID_FORM_CLASS_NAME] + ") {\n\t\t\treturn \"" + (param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue()) + "\";\n\t\t} else ";
                        continue;
                    }
                    if (param.getNodeName().equals("FIELD_SQL")) {
                        sGetSQL_SELECT = "if (item instanceof " + arrFormPopisy[ID_FORM_CLASS_NAME] + ") {\n\t\t\treturn \"" + (param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue()) + "\";\n\t\t} else ";
                        sGetSQL_SELECT_ARRAY = "if (array instanceof " + arrFormPopisy[ID_FORM_CLASS_NAME] + "Array) {\n\t\t\treturn \"" + (param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue()) + "\";\n\t\t} else ";
                        continue;
                    }
                    if (param.getNodeName().equals("FIELD_ARRAY")) {
                        int nFieldCount = 0;
                        arrFields = param.getChildNodes();
                        for (k = 0; k < arrFields.getLength(); ++k) {
                            field = arrFields.item(k);
                            if (field.getNodeType() == 3) continue;
                            sName = "";
                            String sType = "";
                            String sDef = "";
                            String sEdit = "";
                            String sDesc = "";
                            String sRefClass = "";
                            String sRefName = "";
                            NodeList arrFieldName = field.getChildNodes();
                            for (int l = 0; l < arrFieldName.getLength(); ++l) {
                                Node fieldName = arrFieldName.item(l);
                                if (fieldName.getNodeType() == 3) continue;
                                if (fieldName.getNodeName().equals("NAME")) {
                                    sName = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (fieldName.getNodeName().equals("TYPE")) {
                                    sType = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (fieldName.getNodeName().equals("REF_CLASS")) {
                                    sRefClass = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (fieldName.getNodeName().equals("REF_NAME")) {
                                    sRefName = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (fieldName.getNodeName().equals("DEFAULT")) {
                                    sDef = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (fieldName.getNodeName().equals("EDIT")) {
                                    sEdit = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (!fieldName.getNodeName().equals("DESCRIPTION")) continue;
                                sDesc = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                            }
                            sDef = Spinster.FindDefault(sType, sDef);
                            sLoadParam = sLoadParam + "\t" + sType + " " + sName + " = " + sType + ".createInstance(\"" + sName + "\", ";
                            if (sType.equals("MeFieldREF")) {
                                sLoadParam = sLoadParam + sRefClass + ".class, \"" + sRefName + "\", ";
                            }
                            sLoadParam = sLoadParam + sDef + ", " + sEdit + ");\n";
                            sLoadParamDesc = sLoadParamDesc + "\t\t\t" + arrFormPopisy[ID_FORM_CLASS_NAME] + ".m_mapDescParam.put(\"" + sName + "\", \"" + sDesc + "\");\n";
                            sSetGetMetods = sSetGetMetods + Spinster.GenerGetSetMetods(sSetGetMetodsSource, sName, sType, sRefClass);
                            if (Integer.parseInt(arrFormPopisy[ID_FORM_PORADI_ID]) == nFieldCount) {
                                arrFormPopisy[Spinster.ID_FORM_NAME_ID] = sName;
                            }
                            sSetData = sSetData + "\t\tthis." + sName + " = ((" + arrFormPopisy[ID_FORM_CLASS_NAME] + ") zdroj)." + sName + ";\n";
                            sGetParamINT = sGetParamINT + "if (nRow == " + nFieldCount + ") {\n\t\t\treturn " + sName + ";\n\t\t} else ";
                            sGetParamSTRING = sGetParamSTRING + "if (sName.equals(\"" + sName + "\")) {\n\t\t\treturn " + sName + ";\n\t\t} else ";
                            ++nFieldCount;
                        }
                        arrFormPopisy[Spinster.ID_FORM_ATRIBUTES] = "\t// Parametry\n" + sLoadParam + "\n";
                        arrFormPopisy[Spinster.ID_FORM_FIELDS] = "\t\t\t// naplnime pole popisu parametru\n\t\t\t" + arrFormPopisy[ID_FORM_CLASS_NAME] + ".m_mapDescParam = new HashMap();\n" + sLoadParamDesc;
                        arrFormPopisy[Spinster.ID_FORM_PARAMETR_COUNT] = String.valueOf(nFieldCount);
                        arrFormPopisy[Spinster.ID_FORM_SET_DATA] = sSetData;
                        arrFormPopisy[Spinster.ID_FORM_GET_PARAM_INT] = sGetParamINT;
                        arrFormPopisy[Spinster.ID_FORM_GET_PARAM_STRING] = sGetParamSTRING;
                        continue;
                    }
                    if (param.getNodeName().equals("SELECT_SQL")) {
                        sGetSelectSQL = "\t\t\treturn \"" + (param.getFirstChild() == null ? "" : param.getFirstChild().getNodeValue()) + "\";\n";
                        continue;
                    }
                    if (param.getNodeName().equals("SELECT_ARRAY")) {
                        int nSelectCount = 0;
                        NodeList arrGrid = param.getChildNodes();
                        for (k = 0; k < arrGrid.getLength(); ++k) {
                            Node grid = arrGrid.item(k);
                            if (grid.getNodeType() == 3) continue;
                            sGetSelectFields = sGetSelectFields + "\t\t\tarrPopisy[" + nSelectCount + "] = \"" + (grid.getFirstChild() == null ? "" : grid.getFirstChild().getNodeValue()) + "\";\n";
                            ++nSelectCount;
                        }
                        sGetSelectFields = "\t\t\tString[] arrPopisy = new String[" + nSelectCount + "];\n" + sGetSelectFields + "\t\t\treturn arrPopisy;\n";
                        continue;
                    }
                    if (param.getNodeName().equals("VIEW_ARRAY")) {
                        nViewCount = 0;
                        arrFields = param.getChildNodes();
                        for (k = 0; k < arrFields.getLength(); ++k) {
                            field = arrFields.item(k);
                            if (field.getNodeType() == 3) continue;
                            sName = "";
                            String sDesc = "";
                            String sWidth = "";
                            NodeList arrFieldName = field.getChildNodes();
                            for (int l = 0; l < arrFieldName.getLength(); ++l) {
                                Node fieldName = arrFieldName.item(l);
                                if (fieldName.getNodeType() == 3) continue;
                                if (fieldName.getNodeName().equals("NAME")) {
                                    sName = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (fieldName.getNodeName().equals("DESCRIPTION")) {
                                    sDesc = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                                    continue;
                                }
                                if (!fieldName.getNodeName().equals("WIDTH")) continue;
                                sWidth = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                            }
                            sDesc = sDesc == null || sDesc.length() == 0 ? "PensumContext.getRes(this.getDesc(\"" + sName + "\"))" : "PensumContext.getRes(\"" + sDesc + "\")";
                            sViews = sViews + "\t\tarrColumn[" + nViewCount + "] = MeColumn.createInstance(\"" + sName + "\", " + sDesc + ", " + sWidth + ");\n";
                            ++nViewCount;
                        }
                        sViews = MessageFormat.format(sGetColumnsSource, String.valueOf(nViewCount), sViews);
                        continue;
                    }
                    if (!param.getNodeName().equals("SUB_ARRAY")) continue;
                    nViewCount = 0;
                    arrFields = param.getChildNodes();
                    for (k = 0; k < arrFields.getLength(); ++k) {
                        field = arrFields.item(k);
                        if (field.getNodeType() == 3) continue;
                        Object[] arrSubArray = new String[4];
                        NodeList arrFieldName = field.getChildNodes();
                        for (int l = 0; l < arrFieldName.getLength(); ++l) {
                            Node fieldName = arrFieldName.item(l);
                            if (fieldName.getNodeType() == 3) continue;
                            if (fieldName.getNodeName().equals("NAME")) {
                                arrSubArray[0] = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (fieldName.getNodeName().equals("DESCRIPTION")) {
                                arrSubArray[1] = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (fieldName.getNodeName().equals("ID_NAME")) {
                                arrSubArray[2] = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (!fieldName.getNodeName().equals("TYPE")) continue;
                            arrSubArray[3] = fieldName.getFirstChild() == null ? "" : fieldName.getFirstChild().getNodeValue();
                        }
                        sGetSubArrayItem = sGetSubArrayItem + "\t/** " + arrSubArray[1] + " */\n\tprotected " + arrSubArray[3] + " m_arr" + arrSubArray[0] + " = null;\n";
                        sGetSubArrayFun = sGetSubArrayFun + MessageFormat.format(sGetSubArraySource, arrSubArray);
                    }
                }
                if (sGetSelectSQL.length() == 0) {
                    sGetSelectSQL = "\t\t\tthrow new cz.luboss.lubosslib.LException(this.getClass(), \"Prvek tridy " + arrFormPopisy[ID_FORM_CLASS_NAME] + " nema vyberovy SELECT.\");\n";
                }
                sGetSelectSQL = "if (item instanceof " + arrFormPopisy[ID_FORM_CLASS_NAME] + ") {\n" + sGetSelectSQL + "\t\t} else ";
                if (sGetSelectFields.length() == 0) {
                    sGetSelectFields = "\t\t\tthrow new cz.luboss.lubosslib.LException(this.getClass(), \"Prvek tridy " + arrFormPopisy[ID_FORM_CLASS_NAME] + " nema polozky pro vyberovy SELECT.\");\n";
                }
                sGetSelectFields = "if (item instanceof " + arrFormPopisy[ID_FORM_CLASS_NAME] + ") {\n" + sGetSelectFields + "\t\t} else ";
                arrFormPopisy[Spinster.ID_FORM_SETGET_METODS] = sSetGetMetods;
                arrFormPopisy[Spinster.ID_FORM_DATE] = m_forDate.format(new Date());
                arrFormPopisy[Spinster.ID_FORM_SUBARRY] = sGetSubArrayFun + "\n" + sViews;
                arrFormPopisy[Spinster.ID_FORM_NEGENEROVANO] = "\n";
                int n = ID_FORM_ATRIBUTES;
                arrFormPopisy[n] = arrFormPopisy[n] + sGetSubArrayItem;
                Spinster.SaveToFile(sSourceDir + arrFormPopisy[ID_FORM_CLASS_NAME] + ".java", sFileClassSource, arrFormPopisy);
                arrFormPopisy[Spinster.ID_FORM_NEGENEROVANO] = "\n";
                Spinster.SaveToFile(sSourceDir + arrFormPopisy[ID_FORM_CLASS_NAME] + "Array.java", sFileArraySource, arrFormPopisy);
                arrSQLPopisy[2] = arrSQLPopisy[2] + sGetSQL_SELECT;
                arrSQLPopisy[3] = arrSQLPopisy[3] + sGetSQL_SELECT_ARRAY;
                arrSQLPopisy[4] = arrSQLPopisy[4] + sGetSQL_INSERT;
                arrSQLPopisy[5] = arrSQLPopisy[5] + sGetSelectSQL;
                arrSQLPopisy[6] = arrSQLPopisy[6] + sGetSelectFields;
            }
            arrSQLPopisy[1] = m_forDate.format(new Date());
            Spinster.SaveToFile(sSourceDir + sParamClass + ".java", sGetSQLParamSource, arrSQLPopisy);
            System.out.println("   VYGENEROVANO");
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            System.out.println("Generovani doslo k SAXException [" + x + "]");
        }
        catch (ParserConfigurationException pce) {
            System.out.println("Generovani doslo k ParserConfigurationException [" + pce + "]");
        }
        catch (IOException ioe) {
            System.out.println("Generovani doslo k IOException [" + ioe + "]");
        }
    }

    public static boolean SaveToFile(String sFileName, String sFileSourceTemp, String[] arrPopisy) {
        try {
            String sTemp;
            int nFirst;
            boolean bIsNew = true;
            String sSource = "";
            File fSoubor = new File(sFileName);
            if (fSoubor.exists() && (nFirst = (sTemp = Spinster.LoadFile(sFileName)).indexOf("//@@@@ NEGENEROVANO")) != -1) {
                int nLast = sTemp.indexOf("//@@@@ NEGENEROVANO", nFirst + 1);
                arrPopisy[Spinster.ID_FORM_NEGENEROVANO] = sTemp.substring(nFirst + 19, nLast);
                bIsNew = false;
            }
            sSource = MessageFormat.format(sFileSourceTemp, arrPopisy);
            BufferedWriter fWriter = null;
            fWriter = new BufferedWriter(new FileWriter(sFileName));
            if (fWriter == null) {
                System.out.println(" Nepodarilo se otevrit soubor [" + sFileName + "] ");
                return false;
            }
            fWriter.write(sSource);
            fWriter.close();
            if (bIsNew) {
                System.out.println("   Vygenerovan [" + sFileName + "] ");
            } else {
                System.out.println("   Pregenerovan [" + sFileName + "] ");
            }
            return true;
        }
        catch (Exception e) {
            System.out.println(" Pri zapisu do souboru [" + sFileName + "] doslo k chybe [" + e.getMessage() + "]");
            return false;
        }
    }

    public static String LoadFile(String sFileName) {
        String sSourceTemp = "";
        String sRadek = "";
        try {
            BufferedReader fBufReader = new BufferedReader(new FileReader(sFileName));
            while ((sRadek = fBufReader.readLine()) != null) {
                sSourceTemp = sSourceTemp + sRadek + "\n";
            }
            fBufReader.close();
            return sSourceTemp;
        }
        catch (Exception e) {
            System.out.println(" Pri nacitani souboru [" + sFileName + "] doslo k chybe [" + e.getMessage() + "]");
            return null;
        }
    }

    public static String FindDefault(String sType, String sDef) {
        if (sType.equals("MeFieldDATE")) {
            return sDef.length() == 0 ? "" : sDef;
        }
        if (sType.equals("MeFieldFLOAT")) {
            return sDef.length() == 0 ? "0" : sDef;
        }
        if (sType.equals("MeFieldINT")) {
            return sDef.length() == 0 ? "0" : sDef;
        }
        if (sType.equals("MeFieldREF")) {
            return sDef;
        }
        if (sType.equals("MeFieldSTRING")) {
            return "\"" + sDef + "\"";
        }
        return "";
    }

    public static String GenerGetSetMetods(String sSetGetMetodsSource, String sName, String sType, String sRefClass) {
        String sJavaType = "";
        String sFunType = "";
        if (sType.equals("MeFieldDATE")) {
            sJavaType = "java.util.Date";
            sFunType = "Date";
        } else if (sType.equals("MeFieldFLOAT")) {
            sJavaType = "float";
            sFunType = "Float";
        } else if (sType.equals("MeFieldINT")) {
            sJavaType = "int";
            sFunType = "Int";
        } else if (sType.equals("MeFieldREF")) {
            sJavaType = sRefClass;
            sFunType = "Ref";
        } else if (sType.equals("MeFieldSTRING")) {
            sJavaType = "String";
            sFunType = "String";
        }
        String sFunName = String.valueOf(sName.charAt(0)).toUpperCase() + sName.charAt(1) + String.valueOf(sName.charAt(2)).toUpperCase();
        sFunName = sName.endsWith("_id") ? sFunName + sName.substring(3, sName.length() - 3) : sFunName + sName.substring(3);
        Object[] paramSetGet = new String[]{sName, sType, sFunName, sJavaType, sFunType};
        return MessageFormat.format(sSetGetMetodsSource, paramSetGet);
    }

    public static void PrintCommnadLine() {
        System.out.println("\n");
        System.out.println("Pozadovane zadani :");
        System.out.println("Spinster <xmlfile=jmeno_xml> <sourcedir=jmeno_adresare> <paramclass=jmeno_param_tridy>");
        System.out.println("  Parametry :");
        System.out.println("  - jmeno_xml - jmeno souboru s definici trid ");
        System.out.println("  - jmeno_adresare - jmeno adresare, do ktereho se ukladaji vygenerovane soubory ");
        System.out.println("  - jmeno_param_tridy - jmeno tridy s SQL prikazy pro objekty MeItem ");
    }
}

